/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.internal.selector;

import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import opekope2.optigui.filter.ConjunctionFilter;
import opekope2.optigui.filter.DisjunctionFilter;
import opekope2.optigui.filter.EqualityFilter;
import opekope2.optigui.filter.IFilter;
import opekope2.optigui.filter.PreProcessorFilter;
import opekope2.optigui.interaction.Interaction;
import opekope2.optigui.internal.selector.AbstractListSelector;
import opekope2.optigui.internal.util.UtilKt;
import opekope2.optigui.util.NumberOrRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ1\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u001a\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lopekope2/optigui/internal/selector/DateSelector;", "Lopekope2/optigui/internal/selector/AbstractListSelector;", "Lkotlin/Pair;", "Ljava/time/Month;", "Lopekope2/optigui/util/NumberOrRange;", "<init>", "()V", "", "selector", "parseSelector", "(Ljava/lang/String;)Lkotlin/Pair;", "", "invalidSelectors", "", "parseFailed", "(Ljava/util/Collection;)Ljava/lang/Void;", "parsedSelectors", "Lopekope2/optigui/filter/DisjunctionFilter;", "Lopekope2/optigui/interaction/Interaction;", "createFilter", "(Ljava/util/Collection;)Lopekope2/optigui/filter/DisjunctionFilter;", "interaction", "transformInteraction", "(Lopekope2/optigui/interaction/Interaction;)Ljava/lang/String;", "monthName", "getMonth", "(Ljava/lang/String;)Ljava/time/Month;", "Ljava/time/LocalDate;", "getToday", "()Ljava/time/LocalDate;", "today", "optigui"})
@SourceDebugExtension(value={"SMAP\nIndependentSelectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndependentSelectors.kt\nopekope2/optigui/internal/selector/DateSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n1557#2:81\n1628#2,3:82\n*S KotlinDebug\n*F\n+ 1 IndependentSelectors.kt\nopekope2/optigui/internal/selector/DateSelector\n*L\n38#1:81\n38#1:82,3\n*E\n"})
public final class DateSelector
extends AbstractListSelector<Pair<? extends Month, ? extends NumberOrRange>> {
    private final LocalDate getToday() {
        LocalDate localDate = LocalDate.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"now(...)");
        return localDate;
    }

    @Override
    @Nullable
    protected Pair<Month, NumberOrRange> parseSelector(@NotNull String selector) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        char[] cArray = new char[]{'@'};
        List parts = StringsKt.split$default((CharSequence)selector, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        switch (parts.size()) {
            case 1: {
                Month month = this.getMonth((String)parts.get(0));
                if (month == null) {
                    return null;
                }
                pair = TuplesKt.to((Object)month, null);
                break;
            }
            case 2: {
                String rawMonth = (String)parts.get(0);
                String rawDay = (String)parts.get(1);
                Month month = this.getMonth(rawMonth);
                if (month == null) {
                    return null;
                }
                Month month2 = month;
                NumberOrRange day = NumberOrRange.Companion.tryParse(rawDay);
                return TuplesKt.to((Object)month2, (Object)day);
            }
            default: {
                pair = null;
            }
        }
        return pair;
    }

    @Override
    @NotNull
    protected Void parseFailed(@NotNull Collection<String> invalidSelectors) {
        Intrinsics.checkNotNullParameter(invalidSelectors, (String)"invalidSelectors");
        throw new RuntimeException("Invalid dates: " + UtilKt.joinNotFound(invalidSelectors));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected DisjunctionFilter<Interaction> createFilter(@NotNull Collection<? extends Pair<? extends Month, ? extends NumberOrRange>> parsedSelectors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(parsedSelectors, (String)"parsedSelectors");
        Iterable $this$map$iv = parsedSelectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IFilter iFilter;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Month month = (Month)pair.component1();
            NumberOrRange day = (NumberOrRange)pair.component2();
            PreProcessorFilter monthFilter = PreProcessorFilter.Companion.nullGuarded(arg_0 -> DateSelector.createFilter$lambda$2$lambda$0(this, arg_0), "Get month", null, (IFilter)new EqualityFilter<Month>(month));
            Object object = day;
            if (object == null || (object = ((NumberOrRange)object).toFilter()) == null) {
                iFilter = monthFilter;
            } else {
                Object dayFilter = object;
                IFilter[] iFilterArray = new IFilter[]{monthFilter, PreProcessorFilter.Companion.nullGuarded(arg_0 -> DateSelector.createFilter$lambda$2$lambda$1(this, arg_0), "Get day of month", null, dayFilter)};
                iFilter = new ConjunctionFilter(iFilterArray);
            }
            collection.add(iFilter);
        }
        Collection collection = (List)destination$iv$iv;
        return new DisjunctionFilter<Interaction>(collection);
    }

    @Override
    @NotNull
    protected String transformInteraction(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        LocalDate today = this.getToday();
        String string = today.getMonth().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string + "@" + today.getDayOfMonth();
    }

    private final Month getMonth(String monthName) {
        return switch (monthName) {
            case "jan", "1", "january" -> Month.JANUARY;
            case "feb", "february", "2" -> Month.FEBRUARY;
            case "mar", "march", "3" -> Month.MARCH;
            case "april", "apr", "4" -> Month.APRIL;
            case "may", "5" -> Month.MAY;
            case "jun", "june", "6" -> Month.JUNE;
            case "jul", "july", "7" -> Month.JULY;
            case "augustus", "aug", "8" -> Month.AUGUST;
            case "september", "sep", "9" -> Month.SEPTEMBER;
            case "10", "oct", "spooktober", "october" -> Month.OCTOBER;
            case "november", "nov", "11" -> Month.NOVEMBER;
            case "dec", "december", "12" -> Month.DECEMBER;
            default -> null;
        };
    }

    private static final Month createFilter$lambda$2$lambda$0(DateSelector this$0, Interaction it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getToday().getMonth();
    }

    private static final Integer createFilter$lambda$2$lambda$1(DateSelector this$0, Interaction it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getToday().getDayOfMonth();
    }
}

