/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.utils.components;

import btw.lowercase.optiboxes.utils.BlendFunction;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.function.Function;
import org.joml.Vector4f;

public enum Blend {
    ALPHA(alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue()), new BlendFunction(770, 771)),
    ADD(alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue()), new BlendFunction(770, 1)),
    SUBTRACT(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f), new BlendFunction(775, 0)),
    MULTIPLY(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), alpha.floatValue()), new BlendFunction(774, 771)),
    DODGE(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f), new BlendFunction(1, 1)),
    BURN(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f), new BlendFunction(0, 769)),
    SCREEN(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f), new BlendFunction(1, 769)),
    OVERLAY(alpha -> new Vector4f(alpha.floatValue(), alpha.floatValue(), alpha.floatValue(), 1.0f), new BlendFunction(774, 768)),
    REPLACE(alpha -> new Vector4f(1.0f, 1.0f, 1.0f, alpha.floatValue()), null);

    public static final Codec<Blend> CODEC;
    private final Function<Float, Vector4f> blendConsumer;
    private final BlendFunction blendFunction;

    private Blend(Function<Float, Vector4f> blendConsumer, BlendFunction blendFunction) {
        this.blendConsumer = blendConsumer;
        this.blendFunction = blendFunction;
    }

    public static Blend byName(String name) {
        return Arrays.stream(Blend.values()).filter(blend -> blend.toString().toLowerCase().equals(name)).findFirst().orElse(ADD);
    }

    public Vector4f getShaderColor(float value) {
        return this.blendConsumer.apply(Float.valueOf(value));
    }

    public BlendFunction getBlendFunction() {
        return this.blendFunction;
    }

    static {
        CODEC = Codec.STRING.xmap(Blend::byName, Enum::toString);
    }
}

