/*
 * Decompiled with CFR 0.152.
 */
package btw.lowercase.optiboxes.skybox;

import btw.lowercase.optiboxes.OptiBoxesClient;
import btw.lowercase.optiboxes.skybox.OptiFineSkyRenderer;
import btw.lowercase.optiboxes.skybox.OptiFineSkybox;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_638;

public final class SkyboxManager {
    public static final SkyboxManager INSTANCE = new SkyboxManager();
    private final List<OptiFineSkybox> loadedSkyboxes = new ArrayList<OptiFineSkybox>();
    private final List<OptiFineSkybox> activeSkyboxes = new LinkedList<OptiFineSkybox>();

    private SkyboxManager() {
    }

    public void addSkybox(OptiFineSkybox optiFineSkybox) {
        Preconditions.checkNotNull((Object)optiFineSkybox, (Object)"Skybox was null");
        this.loadedSkyboxes.add(optiFineSkybox);
    }

    public void clearSkyboxes() {
        class_310.method_1551().execute(OptiFineSkyRenderer.INSTANCE::clearCache);
        this.loadedSkyboxes.clear();
        this.activeSkyboxes.clear();
    }

    public void tick(class_638 level) {
        for (OptiFineSkybox optiFineSkybox2 : this.loadedSkyboxes) {
            optiFineSkybox2.tick(level);
        }
        this.activeSkyboxes.removeIf(optiFineSkybox -> !optiFineSkybox.isActive());
        for (OptiFineSkybox optiFineSkybox2 : this.loadedSkyboxes) {
            if (this.activeSkyboxes.contains(optiFineSkybox2) || !optiFineSkybox2.isActive()) continue;
            this.activeSkyboxes.add(optiFineSkybox2);
        }
    }

    public boolean isEnabled(class_1937 level) {
        return OptiBoxesClient.getConfig().enabled.isEnabled() && !this.activeSkyboxes.isEmpty() && level != null;
    }

    public List<OptiFineSkybox> getSkiesFor(class_5321<class_1937> resourceKey) {
        return this.getActiveSkyboxes().stream().filter(skybox -> resourceKey.equals(skybox.getWorldResourceKey())).toList();
    }

    public boolean containsEnabled(class_5321<class_1937> resourceKey) {
        return !this.getSkiesFor(resourceKey).isEmpty();
    }

    public List<OptiFineSkybox> getActiveSkyboxes() {
        return this.activeSkyboxes;
    }
}

