/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IGuiRendererInvoker;
import fi.dy.masa.malilib.mixin.render.IMixinAbstractTexture;
import fi.dy.masa.malilib.mixin.render.IMixinDrawContext;
import fi.dy.masa.malilib.mixin.render.IMixinGuiRenderer;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderContext;
import fi.dy.masa.malilib.render.element.MaLiLibBasicRectGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibGradientRectGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibLightTexturedGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibTexturedGuiElement;
import fi.dy.masa.malilib.render.element.MaLiLibTexturedRectGuiElement;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10090;
import net.minecraft.class_1049;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_11228;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11244;
import net.minecraft.class_11245;
import net.minecraft.class_11247;
import net.minecraft.class_11256;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_6880;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_8030;
import net.minecraft.class_9209;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class RenderUtils {
    private static final AnsiLogger LOGGER = new AnsiLogger(RenderUtils.class);
    public static final class_2960 TEXTURE_MAP_BACKGROUND = class_2960.method_60656((String)"textures/map/map_background.png");
    public static final class_2960 TEXTURE_MAP_BACKGROUND_CHECKERBOARD = class_2960.method_60656((String)"textures/map/map_background_checkerboard.png");
    private static final class_6575 RAND = new class_6575(0L);

    @Deprecated
    public static void blend(boolean toggle) {
        if (toggle) {
            GlStateManager._enableBlend();
            GlStateManager._blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        } else {
            GlStateManager._disableBlend();
        }
    }

    @Deprecated
    public static void depthTest(boolean toggle) {
        if (toggle) {
            GlStateManager._enableDepthTest();
        } else {
            GlStateManager._disableDepthTest();
        }
    }

    @Deprecated
    public static void depthFunc(int depth) {
        GlStateManager._depthFunc((int)depth);
    }

    @Deprecated
    public static void depthMask(boolean toggle) {
        GlStateManager._depthMask((boolean)toggle);
    }

    @Deprecated
    public static void culling(boolean toggle) {
        if (toggle) {
            GlStateManager._enableCull();
        } else {
            GlStateManager._disableCull();
        }
    }

    @Deprecated
    public static void polygonOffset(boolean toggle) {
        if (toggle) {
            GlStateManager._enablePolygonOffset();
        } else {
            GlStateManager._disablePolygonOffset();
        }
    }

    @Deprecated
    public static void polygonOffset(float factor, float units) {
        GlStateManager._polygonOffset((float)factor, (float)units);
    }

    @Deprecated
    public static void fbStartDrawing() {
        RenderSystem.assertOnRenderThread();
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    public static class_1049 bindShaderTexture(class_2960 texture, int textureId) throws RuntimeException {
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId + " for texture: " + texture.toString());
        }
        class_1049 tex = (class_1049)RenderUtils.tex().method_4619(texture);
        tex.method_4527(false, false);
        RenderSystem.setShaderTexture((int)textureId, (GpuTextureView)tex.method_71659());
        return tex;
    }

    @Nullable
    public static GpuTexture bindGpuTexture(class_2960 texture) {
        class_1049 tex = (class_1049)RenderUtils.tex().method_4619(texture);
        if (tex != null && ((IMixinAbstractTexture)tex).malilib_getGlTexture() != null) {
            return tex.method_68004();
        }
        return null;
    }

    @Nullable
    public static GpuTextureView bindGpuTextureView(class_2960 texture) {
        class_1049 tex = (class_1049)RenderUtils.tex().method_4619(texture);
        if (tex != null && ((IMixinAbstractTexture)tex).malilib_getGlTextureView() != null) {
            return tex.method_71659();
        }
        MaLiLib.LOGGER.error("bindGpuTextureView: Result is null!");
        return null;
    }

    public static void addSimpleElement(class_332 drawContext, class_11244 simpleElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().method_70919(simpleElement);
    }

    public static void addSpecialElement(class_332 drawContext, class_11256 specialElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().method_70922(specialElement);
    }

    @ApiStatus.Internal
    public static void registerSpecialGuiRenderers(class_11228 guiRenderer, class_4597.class_4598 immediate, class_310 mc) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.putAll(((IMixinGuiRenderer)guiRenderer).malilib_getSpecialGuiRenderers());
        ((RenderEventHandler)RenderEventHandler.getInstance()).onRegisterSpecialGuiRenderer(guiRenderer, immediate, mc, builder);
        ((IGuiRendererInvoker)guiRenderer).malilib$replaceSpecialGuiRenderers((Map<Class<? extends class_11256>, class_11239<?>>)builder.buildOrThrow());
        if (MaLiLibReference.DEBUG_MODE) {
            RenderUtils.dumpBuilderMap(((IMixinGuiRenderer)guiRenderer).malilib_getSpecialGuiRenderers());
        }
    }

    public static void dumpBuilderMap(Map<Class<? extends class_11256>, class_11239<?>> entries) {
        System.out.print("DUMP SpecialGuiRenderers()\n");
        if (entries == null || entries.size() == 0) {
            System.out.print("NULL OR EMPTY!\n");
            return;
        }
        int i = 0;
        for (Class<? extends class_11256> entry : entries.keySet()) {
            System.out.printf("[%d] K (State): [%s], V (Renderer): [%s]\n", i, entry.getName(), entries.get(entry).getClass().getName());
            ++i;
        }
        System.out.print("DUMP END\n");
    }

    public static void addItemElement(class_332 drawContext, class_11245 itemElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().method_70920(itemElement);
    }

    public static void addTextElement(class_332 drawContext, class_11247 textElement) {
        ((IMixinDrawContext)drawContext).malilib_getRenderState().method_70921(textElement);
    }

    public static void pushScissor(class_332 drawContext, @Nonnull class_8030 rect) {
        ((IMixinDrawContext)drawContext).malilib_getScissorStack().method_49700(rect);
    }

    public static boolean containsScissor(class_332 drawContext, int x, int y) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().method_58136(x, y);
    }

    public static class_8030 peekLastScissor(class_332 drawContext) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().method_70863();
    }

    public static class_8030 popScissor(class_332 drawContext) {
        return ((IMixinDrawContext)drawContext).malilib_getScissorStack().method_49699();
    }

    public static void drawOutlinedBox(class_332 drawContext, int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, width, height, colorBg);
        RenderUtils.drawOutline(drawContext, x - 1, y - 1, width + 2, height + 2, colorBorder);
    }

    public static void drawOutlinedBox(class_332 drawContext, int x, int y, int width, int height, float scale, int colorBg, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, width, height, colorBg, scale);
        RenderUtils.drawOutline(drawContext, x - 1, y - 1, width + 2, height + 2, scale, colorBorder);
    }

    public static void drawOutline(class_332 drawContext, int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(drawContext, x, y, width, height, 1, colorBorder);
    }

    public static void drawOutline(class_332 drawContext, int x, int y, int width, int height, float scale, int colorBorder) {
        RenderUtils.drawOutline(drawContext, x, y, width, height, scale, 1, colorBorder);
    }

    public static void drawOutline(class_332 drawContext, int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, borderWidth, height, colorBorder);
        RenderUtils.drawRect(drawContext, x + width - borderWidth, y, borderWidth, height, colorBorder);
        RenderUtils.drawRect(drawContext, x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder);
        RenderUtils.drawRect(drawContext, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder);
    }

    public static void drawOutline(class_332 drawContext, int x, int y, int width, int height, float scale, int borderWidth, int colorBorder) {
        RenderUtils.drawRect(drawContext, x, y, borderWidth, height, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + width - borderWidth, y, borderWidth, height, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, scale);
        RenderUtils.drawRect(drawContext, x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, scale);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, boolean depthMask) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f, 1.0f, depthMask);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, color, zLevel, 1.0f, false);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel, boolean depthMask) {
        RenderUtils.drawRect(x, y, width, height, color, zLevel, 1.0f, depthMask);
    }

    @Deprecated
    public static void drawRect(int x, int y, int width, int height, int color, float zLevel, float scale, boolean depthMask) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderContext ctx = new RenderContext(() -> "malilib:drawRect", depthMask ? MaLiLibPipelines.POSITION_COLOR_MASA_DEPTH_MASK : MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        class_287 buffer = ctx.getBuilder();
        buffer.method_22912((float)x * scale, (float)y * scale, zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)x * scale, (float)(y + height) * scale, zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)(x + width) * scale, (float)(y + height) * scale, zLevel).method_22915(r, g, b, a);
        buffer.method_22912((float)(x + width) * scale, (float)y * scale, zLevel).method_22915(r, g, b, a);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawRect(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawRect(class_332 drawContext, int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(drawContext, x, y, width, height, color, 1.0f);
    }

    public static void drawRect(class_332 drawContext, int x, int y, int width, int height, int color, float scale) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibBasicRectGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), x, y, width, height, scale, color, RenderUtils.peekLastScissor(drawContext)));
    }

    public static void drawScreenBlur(class_310 mc) {
        mc.field_1773.method_57796();
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, class_4588 buffer) {
        RenderUtils.drawTexturedRect(posMatrix, x, y, u, v, width, height, 0.0f, -1, buffer);
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, int color, class_4588 buffer) {
        RenderUtils.drawTexturedRect(posMatrix, x, y, u, v, width, height, 0.0f, color, buffer);
    }

    @Deprecated
    public static void drawTexturedRect(Matrix4f posMatrix, int x, int y, int u, int v, int width, int height, float zLevel, int color, class_4588 buffer) {
        float pixelWidth = 0.00390625f;
        buffer.method_22918(posMatrix, (float)x, (float)(y + height), zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth).method_39415(color);
        buffer.method_22918(posMatrix, (float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).method_39415(color);
        buffer.method_22918(posMatrix, (float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth).method_39415(color);
        buffer.method_22918(posMatrix, (float)x, (float)y, zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth).method_39415(color);
    }

    public static void drawTexturedRect(class_332 drawContext, class_2960 texture, int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(drawContext, texture, x, y, u, v, width, height, 0.0f, -1);
    }

    public static void drawTexturedRect(class_332 drawContext, class_2960 texture, int x, int y, int u, int v, int width, int height, float zLevel) {
        RenderUtils.drawTexturedRect(drawContext, texture, x, y, u, v, width, height, zLevel, -1);
    }

    public static void drawTexturedRect(class_332 drawContext, class_2960 texture, int x, int y, int u, int v, int width, int height, float zLevel, int argb) {
        float pixelWidth = 0.00390625f;
        GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(texture);
        if (gpuTextureView == null) {
            MaLiLib.LOGGER.error("drawTexturedRect(): GpuTextureView for '{}' is null!", (Object)texture.toString());
            return;
        }
        RenderUtils.addSimpleElement(drawContext, new MaLiLibTexturedGuiElement(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), x, y, x + width, y + height, (float)u * pixelWidth, (float)(u + width) * pixelWidth, (float)v * pixelWidth, (float)(v + height) * pixelWidth, argb, RenderUtils.peekLastScissor(drawContext)));
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, class_4588 buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, -1, buffer);
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, int argb, class_4588 buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, argb, buffer);
    }

    @Deprecated
    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, int argb, class_4588 buffer) {
        float pixelWidth = 0.00390625f;
        buffer.method_22912((float)x, (float)(y + height), zLevel).method_22913((float)u * pixelWidth, (float)(v + height) * pixelWidth).method_39415(argb);
        buffer.method_22912((float)(x + width), (float)(y + height), zLevel).method_22913((float)(u + width) * pixelWidth, (float)(v + height) * pixelWidth).method_39415(argb);
        buffer.method_22912((float)(x + width), (float)y, zLevel).method_22913((float)(u + width) * pixelWidth, (float)v * pixelWidth).method_39415(argb);
        buffer.method_22912((float)x, (float)y, zLevel).method_22913((float)u * pixelWidth, (float)v * pixelWidth).method_39415(argb);
    }

    public static void drawTexturedRectBatched(class_332 drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRectBatched(drawContext, gpuTextureView, x, y, u, v, width, height, 0.0f, -1);
    }

    public static void drawTexturedRectBatched(class_332 drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height, int argb) {
        RenderUtils.drawTexturedRectBatched(drawContext, gpuTextureView, x, y, u, v, width, height, 0.0f, argb);
    }

    public static void drawTexturedRectBatched(class_332 drawContext, @Nonnull GpuTextureView gpuTextureView, int x, int y, int u, int v, int width, int height, float zLevel, int argb) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibTexturedRectGuiElement(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), x, y, u, v, width, height, argb, RenderUtils.peekLastScissor(drawContext)));
    }

    public static void drawHoverText(class_332 drawContext, int x, int y, List<String> textLines) {
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            class_327 font = RenderUtils.mc().field_1772;
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().field_22789;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.method_1727(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            Objects.requireNonNull(font);
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            drawContext.method_51448().pushMatrix();
            drawContext.method_51448().translate(0.0f, 0.0f);
            float zLevel = 300.0f;
            int borderColor = -267386864;
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, borderColor, borderColor);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, fillColor1, fillColor2);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, fillColor1, fillColor2);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, fillColor1, fillColor1);
            RenderUtils.drawGradientRectBatched(drawContext, textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                drawContext.method_51433(font, str, textStartX, textStartY, -1, false);
                textStartY += lineHeight;
            }
            drawContext.method_51448().popMatrix();
        }
    }

    public static void drawGradientRectBatched(class_332 drawContext, float left, float top, float right, float bottom, int startColor, int endColor) {
        RenderUtils.addSimpleElement(drawContext, new MaLiLibGradientRectGuiElement(class_10799.field_56879, class_11231.method_70899(), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), left, top, right, bottom, startColor, endColor, RenderUtils.peekLastScissor(drawContext)));
    }

    @Deprecated
    public static void drawGradientRect(float left, float top, float right, float bottom, float zLevel, int startColor, int endColor) {
        int sa = startColor >> 24 & 0xFF;
        int sr = startColor >> 16 & 0xFF;
        int sg = startColor >> 8 & 0xFF;
        int sb = startColor & 0xFF;
        int ea = endColor >> 24 & 0xFF;
        int er = endColor >> 16 & 0xFF;
        int eg = endColor >> 8 & 0xFF;
        int eb = endColor & 0xFF;
        RenderContext ctx = new RenderContext(() -> "malilib:drawGradientRect", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        class_287 buffer = ctx.getBuilder();
        buffer.method_22912(right, top, zLevel).method_1336(sr, sg, sb, sa);
        buffer.method_22912(left, top, zLevel).method_1336(sr, sg, sb, sa);
        buffer.method_22912(left, bottom, zLevel).method_1336(er, eg, eb, ea);
        buffer.method_22912(right, bottom, zLevel).method_1336(er, eg, eb, ea);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawGradientRect(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawCenteredString(class_332 drawContext, int x, int y, int color, String text) {
        drawContext.method_25300(RenderUtils.mc().field_1772, text, x, y, color);
    }

    public static void drawHorizontalLine(class_332 drawContext, int x, int y, int width, int color) {
        RenderUtils.drawRect(drawContext, x, y, width, 1, color);
    }

    public static void drawVerticalLine(class_332 drawContext, int x, int y, int height, int color) {
        RenderUtils.drawRect(drawContext, x, y, 1, height, color);
    }

    public static void renderSprite(class_332 drawContext, class_2960 atlas, class_2960 texture, int x, int y, int width, int height) {
        class_1058 sprite;
        if (texture != null && (sprite = RenderUtils.mc().method_72703().method_73025(atlas).method_4608(texture)) != null) {
            drawContext.method_52710(class_10799.field_56883, sprite, x, y, width, height, -1);
        }
    }

    public static void renderText(class_332 drawContext, int x, int y, int color, String text) {
        String[] parts = text.split("\\\\n");
        class_327 textRenderer = RenderUtils.mc().field_1772;
        for (String line : parts) {
            drawContext.method_51433(textRenderer, line, x, y, color, true);
            Objects.requireNonNull(textRenderer);
            y += 9 + 1;
        }
    }

    public static void renderText(class_332 drawContext, int x, int y, int color, List<String> lines) {
        if (!lines.isEmpty()) {
            class_327 textRenderer = RenderUtils.mc().field_1772;
            for (String line : lines) {
                drawContext.method_51433(textRenderer, line, x, y, color, false);
                Objects.requireNonNull(textRenderer);
                y += 9 + 2;
            }
        }
    }

    public static int renderText(class_332 drawContext, int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines) {
        return RenderUtils.renderText(drawContext, xOff, yOff, scale, textColor, bgColor, alignment, useBackground, useShadow, true, lines);
    }

    public static int renderText(class_332 drawContext, int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, boolean useStatusShift, List<String> lines) {
        boolean scaled;
        class_327 fontRenderer = RenderUtils.mc().field_1772;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale < 0.0125) {
            return 0;
        }
        boolean bl = scaled = scale != 1.0;
        if (scaled) {
            drawContext.method_51448().pushMatrix();
            drawContext.method_51448().scale((float)scale, (float)scale);
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        if (useStatusShift) {
            posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (class_1657)RenderUtils.mc().field_1724);
        }
        for (String line : lines) {
            int width = fontRenderer.method_1727(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)width / 2.0 - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                Objects.requireNonNull(fontRenderer);
                RenderUtils.drawRect(drawContext, x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            drawContext.method_51433(fontRenderer, line, x, y, textColor, useShadow);
        }
        if (scaled) {
            drawContext.method_51448().popMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, class_1657 player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.method_6026();
            boolean hasTurtleHelmet = EntityUtils.hasTurtleHelmetEquipped(player);
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (class_1293 effectInstance : effects) {
                    class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
                    if (!effectInstance.method_5581() || !effectInstance.method_5592()) continue;
                    if (effect.method_5573()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                if (hasTurtleHelmet && y1 == 0) {
                    y1 = 26;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
            if (hasTurtleHelmet) {
                return (int)(26.0 / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand);
        float minY = (float)((double)pos.method_10264() - expand);
        float minZ = (float)((double)pos.method_10260() - expand);
        float maxX = (float)((double)pos.method_10263() + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - cameraPos.field_1352 - expand);
        float minY = (float)((double)pos.method_10264() - cameraPos.field_1351 - expand);
        float minZ = (float)((double)pos.method_10260() - cameraPos.field_1350 - expand);
        float maxX = (float)((double)pos.method_10263() - cameraPos.field_1352 + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - cameraPos.field_1351 + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - cameraPos.field_1350 + expand + 1.0);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, class_243.field_1353, color, expand, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, class_243 cameraPos, Color4f color, double expand, class_287 buffer) {
        float minX = (float)((double)pos.method_10263() - expand - cameraPos.field_1352);
        float minY = (float)((double)pos.method_10264() - expand - cameraPos.field_1351);
        float minZ = (float)((double)pos.method_10260() - expand - cameraPos.field_1350);
        float maxX = (float)((double)pos.method_10263() + expand - cameraPos.field_1352 + 1.0);
        float maxY = (float)((double)pos.method_10264() + expand - cameraPos.field_1351 + 1.0);
        float maxZ = (float)((double)pos.method_10260() + expand - cameraPos.field_1350 + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        RenderUtils.drawBoxWithEdgesBatched(posMin, posMax, class_243.field_1353, colorLines, colorSides, bufferQuads, bufferLines);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, class_243 cameraPos, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        float x1 = (float)((double)posMin.method_10263() - cameraPos.field_1352);
        float y1 = (float)((double)posMin.method_10264() - cameraPos.field_1351);
        float z1 = (float)((double)posMin.method_10260() - cameraPos.field_1350);
        float x2 = (float)((double)(posMax.method_10263() + 1) - cameraPos.field_1352);
        float y2 = (float)((double)(posMax.method_10264() + 1) - cameraPos.field_1351);
        float z2 = (float)((double)(posMax.method_10260() + 1) - cameraPos.field_1350);
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxTopBatchedQuads(float minX, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxBottomBatchedQuads(float minX, float minY, float minZ, float maxX, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBoxAllEdgesBatchedLines(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color, class_287 buffer) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void drawBox(IntBoundingBox bb, class_243 cameraPos, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        float minX = (float)((double)bb.minX - cameraPos.field_1352);
        float minY = (float)((double)bb.minY - cameraPos.field_1351);
        float minZ = (float)((double)bb.minZ - cameraPos.field_1350);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.field_1352);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.field_1351);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.field_1350);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawBoxNoOutlines(IntBoundingBox bb, class_243 cameraPos, Color4f color, class_287 bufferQuads) {
        float minX = (float)((double)bb.minX - cameraPos.field_1352);
        float minY = (float)((double)bb.minY - cameraPos.field_1351);
        float minZ = (float)((double)bb.minZ - cameraPos.field_1350);
        float maxX = (float)((double)(bb.maxX + 1) - cameraPos.field_1352);
        float maxY = (float)((double)(bb.maxY + 1) - cameraPos.field_1351);
        float maxZ = (float)((double)(bb.maxZ + 1) - cameraPos.field_1350);
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        class_1297 entity = RenderUtils.mc().method_1560();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.method_36454(), entity.method_36455(), scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        class_243 cameraPos = RenderUtils.camPos();
        double cx = cameraPos.field_1352;
        double cy = cameraPos.field_1351;
        double cz = cameraPos.field_1350;
        class_327 textRenderer = RenderUtils.mc().field_1772;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        global4fStack.translate((float)(x - cx), (float)(y - cy), (float)(z - cz));
        global4fStack.rotateYXZ(-yaw * ((float)Math.PI / 180), pitch * ((float)Math.PI / 180), 0.0f);
        global4fStack.scale(-scale, -scale, scale);
        RenderUtils.culling(false);
        RenderUtils.blend(true);
        RenderContext ctx = new RenderContext(() -> "malilib:drawTextPlate", MaLiLibPipelines.POSITION_COLOR_MASA);
        class_287 buffer = ctx.getBuilder();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.method_1727(line));
        }
        int strLenHalf = maxLineLen / 2;
        Objects.requireNonNull(textRenderer);
        int textHeight = 9 * text.size() - 1;
        int bga = bgColor >>> 24 & 0xFF;
        int bgr = bgColor >>> 16 & 0xFF;
        int bgg = bgColor >>> 8 & 0xFF;
        int bgb = bgColor & 0xFF;
        if (disableDepth) {
            RenderUtils.depthTest(false);
        }
        buffer.method_22912((float)(-strLenHalf - 1), -1.0f, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)(-strLenHalf - 1), (float)textHeight, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)strLenHalf, (float)textHeight, 0.0f).method_1336(bgr, bgg, bgb, bga);
        buffer.method_22912((float)strLenHalf, -1.0f, 0.0f).method_1336(bgr, bgg, bgb, bga);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawTextPlate(): Draw Exception; {}", (Object)err.getMessage());
        }
        int textY = 0;
        if (!disableDepth) {
            RenderUtils.polygonOffset(true);
            RenderUtils.polygonOffset(-0.6f, -1.2f);
        }
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.identity();
        class_9799 allocator = new class_9799(1536);
        for (String line : text) {
            class_4597.class_4598 immediate;
            if (disableDepth) {
                RenderUtils.depthTest(false);
                immediate = class_4597.method_22991((class_9799)allocator);
                textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF, false, modelMatrix, (class_4597)immediate, class_327.class_6415.field_33994, 0, 0xF000F0);
                immediate.method_22993();
                RenderUtils.depthTest(true);
            }
            immediate = class_4597.method_22991((class_9799)allocator);
            textRenderer.method_27521(line, (float)(-strLenHalf), (float)textY, textColor, false, modelMatrix, (class_4597)immediate, class_327.class_6415.field_33994, 0, 0xF000F0);
            immediate.method_22993();
            Objects.requireNonNull(textRenderer);
            textY += 9;
        }
        allocator.close();
        if (!disableDepth) {
            RenderUtils.polygonOffset(0.0f, 0.0f);
            RenderUtils.polygonOffset(false);
        }
        RenderUtils.culling(true);
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, Color4f color, Matrix4f posMatrix) {
        class_9801 meshData;
        class_2350 playerFacing = entity.method_5735();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        class_243 cameraPos = RenderUtils.camPos();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockTargetingOverlay Side", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        class_287 buffer = ctx.getBuilder();
        int quadAlpha = 45;
        int hr = (int)(color.r * 255.0f);
        int hg = (int)(color.g * 255.0f);
        int hb = (int)(color.b * 255.0f);
        int ha = (int)(color.a * 255.0f);
        int c = 255;
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, quadAlpha);
        switch (part) {
            case CENTER: {
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case LEFT: {
                buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case RIGHT: {
                buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case TOP: {
                buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
            case BOTTOM: {
                buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(hr, hg, hb, ha);
                buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(hr, hg, hb, ha);
                break;
            }
        }
        try {
            class_9801 meshData2 = buffer.method_60794();
            if (meshData2 != null) {
                ctx.draw(meshData2, false);
                meshData2.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():1: Draw Exception; {}", (Object)err.getMessage());
        }
        int wireColor = -1;
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlay/center", MaLiLibPipelines.DEBUG_LINE_STRIP_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        try {
            meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.color(wireColor);
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():2: Draw Exception; {}", (Object)err.getMessage());
        }
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlay/edges", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y - 0.25), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.25), (float)(y + 0.25), (float)z).method_1336(c, c, c, c);
        try {
            meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.color(wireColor);
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlay():3: Draw Exception; {}", (Object)err.getMessage());
        }
        global4fStack.popMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(class_1297 entity, class_2338 pos, class_2350 side, Color4f color, Matrix4f posMatrix) {
        class_9801 meshData;
        class_2350 playerFacing = entity.method_5735();
        class_243 cameraPos = RenderUtils.camPos();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        Matrix4fStack global4fStack = RenderSystem.getModelViewStack();
        global4fStack.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing, global4fStack);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockTargetingOverlaySimple/quads", MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL);
        class_287 buffer = ctx.getBuilder();
        int a = (int)(color.a * 255.0f);
        int r = (int)(color.r * 255.0f);
        int g = (int)(color.g * 255.0f);
        int b = (int)(color.b * 255.0f);
        int c = 255;
        buffer.method_22912((float)(x - 0.5), (float)(y - 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x + 0.5), (float)(y - 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x + 0.5), (float)(y + 0.5), (float)z).method_1336(r, g, b, a);
        buffer.method_22912((float)(x - 0.5), (float)(y + 0.5), (float)z).method_1336(r, g, b, a);
        try {
            meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.draw(meshData, false);
                meshData.close();
            }
            ctx.reset();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlaySimple():1: Draw Exception; {}", (Object)err.getMessage());
        }
        buffer = ctx.start(() -> "malilib:renderBlockTargetingOverlaySimple/lines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        buffer.method_22912((float)(x - 0.375), (float)(y - 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.375), (float)(y - 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x + 0.375), (float)(y + 0.375), (float)z).method_1336(c, c, c, c);
        buffer.method_22912((float)(x - 0.375), (float)(y + 0.375), (float)z).method_1336(c, c, c, c);
        try {
            meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.lineWidth(1.6f);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockTargetingOverlaySimple():2: Draw Exception; {}", (Object)err.getMessage());
        }
        global4fStack.popMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, class_2350 side, class_2350 playerFacing, Matrix4fStack matrix4fStack) {
        matrix4fStack.translate((float)x, (float)y, (float)z);
        switch (side) {
            case field_11033: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.method_10144()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(90.0f));
                break;
            }
            case field_11036: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f - playerFacing.method_10144()));
                matrix4fStack.rotateX(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11043: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(180.0f));
                break;
            }
            case field_11035: {
                break;
            }
            case field_11039: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(-90.0f));
                break;
            }
            case field_11034: {
                matrix4fStack.rotateY(RenderUtils.matrix4fRotateFix(90.0f));
            }
        }
        matrix4fStack.translate((float)(-x), (float)(-y), (float)(-z + 0.51));
    }

    public static void renderMapPreview(class_332 drawContext, class_1799 stack, int x, int y, int dimensions) {
        RenderUtils.renderMapPreview(drawContext, stack, x, y, dimensions, true);
    }

    public static void renderMapPreview(class_332 drawContext, class_1799 stack, int x, int y, int dimensions, boolean requireShift) {
        if (stack.method_7909() instanceof class_1806 && (!requireShift || GuiBase.isShiftDown())) {
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            int uv = 0xF000F0;
            class_22 mapState = class_1806.method_8001((class_1799)stack, (class_1937)RenderUtils.mc().field_1687);
            class_9323 data = stack.method_57353();
            class_9209 mapId = (class_9209)data.method_58694(class_9334.field_49646);
            class_2960 bgTexture = mapState == null ? TEXTURE_MAP_BACKGROUND : TEXTURE_MAP_BACKGROUND_CHECKERBOARD;
            GpuTextureView gpuTextureView = RenderUtils.bindGpuTextureView(bgTexture);
            if (gpuTextureView == null) {
                MaLiLib.LOGGER.error("renderMapPreview(): Failed to bind GpuTexture!");
                return;
            }
            RenderUtils.addSimpleElement(drawContext, new MaLiLibLightTexturedGuiElement(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), x1, y1, x2, y2, 0.0f, 1.0f, 0.0f, 1.0f, -1, uv, RenderUtils.peekLastScissor(drawContext)));
            if (mapId != null && mapState != null) {
                double scale = (double)(dimensions - 16) / 128.0;
                drawContext.method_51448().pushMatrix();
                drawContext.method_51448().translate((float)(x1 += 8), (float)(y1 += 8));
                drawContext.method_51448().scale((float)scale, (float)scale);
                class_10090 mapRenderState = new class_10090();
                RenderUtils.mc().method_61965().method_62230(mapId, mapState, mapRenderState);
                drawContext.method_70857(mapRenderState);
                drawContext.method_51448().popMatrix();
            }
        }
    }

    public static void renderShulkerBoxPreview(class_332 drawContext, class_1799 stack, int baseX, int baseY, boolean useBgColors) {
        if (stack.method_57353().method_57832(class_9334.field_49622)) {
            class_2371<class_1799> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.isEmpty()) {
                return;
            }
            class_2487 nbt = InventoryUtils.getStoredBlockEntityNbt(stack);
            HashSet<Integer> lockedSlots = new HashSet();
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480 ? RenderUtils.setShulkerboxBackgroundTintColor((class_2480)((class_1747)stack.method_7909()).method_7711(), useBgColors) : -1;
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, props.totalSlots, color, RenderUtils.mc());
            color = -1;
            if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                InventoryOverlay.renderBrewerBackgroundSlots(drawContext, inv, x, y);
            }
            if (type == InventoryOverlay.InventoryRenderType.CRAFTER && !nbt.method_33133()) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(nbt);
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, lockedSlots, RenderUtils.mc());
            } else {
                InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            }
            matrix4fStack.popMatrix();
        }
    }

    public static void renderBundlePreview(class_332 drawContext, class_1799 stack, int baseX, int baseY, boolean useBgColors) {
        RenderUtils.renderBundlePreview(drawContext, stack, baseX, baseY, 9, useBgColors);
    }

    public static void renderBundlePreview(class_332 drawContext, class_1799 stack, int baseX, int baseY, int slotsPerRow, boolean useBgColors) {
        if (stack.method_57353().method_57832(class_9334.field_49650)) {
            int count = InventoryUtils.bundleCountItems(stack);
            class_2371<class_1799> items = InventoryUtils.getBundleItems(stack, count);
            int n = slotsPerRow = slotsPerRow != 9 ? MathUtils.clamp(slotsPerRow, 6, 9) : 9;
            if (items.isEmpty()) {
                return;
            }
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, count, slotsPerRow);
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = RenderUtils.setBundleBackgroundTintColor(stack, useBgColors);
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, props.totalSlots, color, RenderUtils.mc());
            InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, count, RenderUtils.mc());
            matrix4fStack.popMatrix();
        }
    }

    public static void renderNbtItemsPreview(class_332 drawContext, class_1799 stackIn, @Nonnull class_2487 itemsTag, int baseX, int baseY, boolean useBgColors) {
        if (InventoryUtils.hasNbtItems(itemsTag)) {
            if (RenderUtils.mc().field_1687 == null) {
                return;
            }
            class_2371<class_1799> items = InventoryUtils.getNbtItems(itemsTag, -1, RenderUtils.mc().field_1687.method_30349());
            if (items.size() == 0) {
                return;
            }
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stackIn);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            int screenWidth = GuiUtils.getScaledWindowWidth();
            int screenHeight = GuiUtils.getScaledWindowHeight();
            int height = props.height + 18;
            int x = class_3532.method_15340((int)(baseX + 8), (int)0, (int)(screenWidth - props.width));
            int y = class_3532.method_15340((int)(baseY - height), (int)0, (int)(screenHeight - height));
            int color = -1;
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translate(0.0f, 0.0f, 500.0f);
            InventoryOverlay.renderInventoryBackground(drawContext, type, x, y, props.slotsPerRow, items.size(), color, RenderUtils.mc());
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(drawContext, type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            matrix4fStack.popMatrix();
        }
    }

    public static int setShulkerboxBackgroundTintColor(@Nullable class_2480 block, boolean useBgColors) {
        if (block != null && useBgColors) {
            float[] colors = RenderUtils.getColorComponents(block.method_10528() != null ? block.method_10528().method_7787() : -7905401);
            return class_9848.method_61318((float)1.0f, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
        return -1;
    }

    public static float[] getColorComponents(int color) {
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static int setBundleBackgroundTintColor(class_1799 bundle, boolean useBgColors) {
        if (bundle.method_31573(class_3489.field_54294) && useBgColors) {
            return RenderUtils.getBundleColor(bundle);
        }
        return -1;
    }

    public static int getBundleColor(class_1799 bundle) {
        class_1792 item = bundle.method_7909();
        if (item == null) {
            return -1;
        }
        if (item.equals(class_1802.field_54302)) {
            return -1644826;
        }
        if (item.equals(class_1802.field_54303)) {
            return -290016;
        }
        if (item.equals(class_1802.field_54304)) {
            return -3388999;
        }
        if (item.equals(class_1802.field_54305)) {
            return -13586459;
        }
        if (item.equals(class_1802.field_54306)) {
            return -866555;
        }
        if (item.equals(class_1802.field_54307)) {
            return -6561991;
        }
        if (item.equals(class_1802.field_54308)) {
            return -481603;
        }
        if (item.equals(class_1802.field_54309)) {
            return -9667709;
        }
        if (item.equals(class_1802.field_54310)) {
            return -5133149;
        }
        if (item.equals(class_1802.field_54311)) {
            return -15420236;
        }
        if (item.equals(class_1802.field_54313)) {
            return -12225593;
        }
        if (item.equals(class_1802.field_54314)) {
            return -3044775;
        }
        if (item.equals(class_1802.field_54315)) {
            return -8937191;
        }
        if (item.equals(class_1802.field_54316)) {
            return -3000274;
        }
        if (item.equals(class_1802.field_54317)) {
            return -13093297;
        }
        if (item.equals(class_1802.field_54312)) {
            return -7066934;
        }
        return -5875924;
    }

    public static int setVillagerBackgroundTintColor(class_3850 data, boolean useBgColors) {
        if (useBgColors) {
            class_6880 profession = data != null ? data.comp_3521() : null;
            return RenderUtils.setVillagerBackgroundTintColor((class_6880<class_3852>)profession, useBgColors);
        }
        return -1;
    }

    public static int setVillagerBackgroundTintColor(class_6880<class_3852> profession, boolean useBgColors) {
        class_1767 dye;
        if (useBgColors && (dye = RenderUtils.getVillagerColor(profession)) != null) {
            float[] colors = RenderUtils.getColorComponents(dye.method_7787());
            return class_9848.method_61318((float)1.0f, (float)colors[0], (float)colors[1], (float)colors[2]);
        }
        return -1;
    }

    public static class_1767 getVillagerColor(class_6880<class_3852> profession) {
        if (profession == null) {
            return null;
        }
        if (profession.equals((Object)class_3852.field_17051)) {
            return class_1767.field_7966;
        }
        if (profession.method_40225(class_3852.field_17052)) {
            return class_1767.field_7944;
        }
        if (profession.method_40225(class_3852.field_17053)) {
            return class_1767.field_7954;
        }
        if (profession.method_40225(class_3852.field_17054)) {
            return class_1767.field_7951;
        }
        if (profession.method_40225(class_3852.field_17055)) {
            return class_1767.field_7945;
        }
        if (profession.method_40225(class_3852.field_17056)) {
            return class_1767.field_7947;
        }
        if (profession.method_40225(class_3852.field_17057)) {
            return class_1767.field_7955;
        }
        if (profession.method_40225(class_3852.field_17058)) {
            return class_1767.field_7946;
        }
        if (profession.method_40225(class_3852.field_17059)) {
            return class_1767.field_7957;
        }
        if (profession.method_40225(class_3852.field_17060)) {
            return class_1767.field_7964;
        }
        if (profession.method_40225(class_3852.field_17061)) {
            return class_1767.field_7958;
        }
        if (profession.method_40225(class_3852.field_17062)) {
            return class_1767.field_7942;
        }
        if (profession.method_40225(class_3852.field_17063)) {
            return class_1767.field_7952;
        }
        if (profession.method_40225(class_3852.field_17064)) {
            return class_1767.field_7967;
        }
        if (profession.method_40225(class_3852.field_17065)) {
            return class_1767.field_7963;
        }
        return class_1767.field_7961;
    }

    public static boolean stateModelHasQuads(class_2680 state) {
        return RenderUtils.modelHasQuads(Objects.requireNonNull(class_310.method_1551().method_1541().method_3349(state)));
    }

    public static boolean modelHasQuads(@Nonnull class_1087 model) {
        return RenderUtils.hasQuads(model.method_68512((class_5819)new class_6575(0L)));
    }

    public static boolean hasQuads(List<class_10889> modelParts) {
        if (modelParts.isEmpty()) {
            return false;
        }
        int totalSize = 0;
        for (class_10889 part : modelParts) {
            for (class_2350 face : PositionUtils.ALL_DIRECTIONS) {
                totalSize += part.method_68509(face).size();
            }
            totalSize += part.method_68509(null).size();
        }
        return totalSize > 0;
    }

    public static void renderModelInGui(class_332 drawContext, int x, int y, class_2680 state) {
        RenderUtils.renderModelInGui(drawContext, x, y, 16, 0.0f, state, 0.625f);
    }

    public static void renderModelInGui(class_332 drawContext, int x, int y, int size, float zLevel, class_2680 state, float scale) {
        if (state.method_26204() == class_2246.field_10124) {
            return;
        }
    }

    private static void renderModel(class_1087 model, class_2680 state, class_4587 matrices, class_287 builder) {
        class_6575 random = new class_6575(0L);
        List parts = model.method_68512((class_5819)random);
        class_4587.class_4665 entry = matrices.method_23760();
        int l = class_765.method_23687((int)15, (int)15);
        int[] light = new int[]{l, l, l, l};
        float[] brightness = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
        for (class_10889 part : parts) {
            for (class_2350 face : PositionUtils.ALL_DIRECTIONS) {
                random.method_43052(0L);
                RenderUtils.renderQuads(part.method_68509(face), brightness, light, entry, builder);
            }
            random.method_43052(0L);
            RenderUtils.renderQuads(part.method_68509(null), brightness, light, entry, builder);
        }
    }

    private static void renderQuads(List<class_777> quads, float[] brightness, int[] light, class_4587.class_4665 matrixEntry, class_287 builder) {
        for (class_777 quad : quads) {
            RenderUtils.renderQuad(quad, brightness, light, matrixEntry, builder);
        }
    }

    private static void renderQuad(class_777 quad, float[] brightness, int[] light, class_4587.class_4665 matrixEntry, class_287 builder) {
        builder.method_22920(matrixEntry, quad, brightness, 1.0f, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444, true);
    }

    private static void renderModelQuadOverlayBatched(class_2338 pos, class_287 buffer, Color4f color, class_777 quad) {
        int[] vertexData = quad.comp_3721();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int vertexSize = vertexData.length / 4;
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * vertexSize]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * vertexSize + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * vertexSize + 2]);
            buffer.method_22912(fx, fy, fz).method_22915(color.r, color.g, color.b, color.a);
        }
    }

    public static class_310 mc() {
        return class_310.method_1551();
    }

    public static class_276 fb() {
        return RenderUtils.mc().method_1522();
    }

    public static class_243 camPos() {
        return RenderUtils.mc().field_1773.method_19418().method_19326();
    }

    public static class_1060 tex() {
        return RenderUtils.mc().method_1531();
    }

    public static class_765 lightmap() {
        return RenderUtils.mc().field_1773.method_22974();
    }

    public static float matrix4fRotateFix(float ang) {
        return ang * ((float)Math.PI / 180);
    }

    public static void renderBlockOutline(class_2338 pos, float expand, float lineWidth, Color4f color) {
        RenderUtils.renderBlockOutline(pos, expand, lineWidth, color, false);
    }

    public static void renderBlockOutline(class_2338 pos, float expand, float lineWidth, Color4f color, boolean renderThrough) {
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockOutline", renderThrough ? MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL : MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        class_287 buffer = ctx.getBuilder();
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLinesSimple(pos, color, expand, buffer);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockOutline(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLinesSimple(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float minX = (float)((double)pos.method_10263() - dx - expand);
        float minY = (float)((double)pos.method_10264() - dy - expand);
        float minZ = (float)((double)pos.method_10260() - dz - expand);
        float maxX = (float)((double)pos.method_10263() - dx + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - dz + expand + 1.0);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawConnectingLineBatchedLines(class_2338 pos1, class_2338 pos2, boolean center, Color4f color, class_287 buffer) {
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float x1 = (float)((double)pos1.method_10263() - dx);
        float y1 = (float)((double)pos1.method_10264() - dy);
        float z1 = (float)((double)pos1.method_10260() - dz);
        float x2 = (float)((double)pos2.method_10263() - dx);
        float y2 = (float)((double)pos2.method_10264() - dy);
        float z2 = (float)((double)pos2.method_10260() - dz);
        if (center) {
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
            x2 += 0.5f;
            y2 += 0.5f;
            z2 += 0.5f;
        }
        buffer.method_22912(x1, y1, z1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x2, y2, z2).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderBlockOutlineOverlapping(class_2338 pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f) {
        RenderUtils.renderBlockOutlineOverlapping(pos, expand, lineWidth, color1, color2, color3, matrix4f, false);
    }

    public static void renderBlockOutlineOverlapping(class_2338 pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f, boolean renderThrough) {
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float minX = (float)((double)pos.method_10263() - dx - (double)expand);
        float minY = (float)((double)pos.method_10264() - dy - (double)expand);
        float minZ = (float)((double)pos.method_10260() - dz - (double)expand);
        float maxX = (float)((double)pos.method_10263() - dx + (double)expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - dy + (double)expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - dz + (double)expand + 1.0);
        RenderContext ctx = new RenderContext(() -> "malilib:renderBlockOutlineOverlapping", renderThrough ? MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL : MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        class_287 buffer = ctx.getBuilder();
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderBlockOutlineOverlapping(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void renderAreaOutline(class_2338 pos1, class_2338 pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ) {
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        double minX = (double)Math.min(pos1.method_10263(), pos2.method_10263()) - dx;
        double minY = (double)Math.min(pos1.method_10264(), pos2.method_10264()) - dy;
        double minZ = (double)Math.min(pos1.method_10260(), pos2.method_10260()) - dz;
        double maxX = (double)Math.max(pos1.method_10263(), pos2.method_10263()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.method_10264(), pos2.method_10264()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.method_10260(), pos2.method_10260()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, colorX, colorY, colorZ, lineWidth);
    }

    private static void drawBoundingBoxEdges(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f colorX, Color4f colorY, Color4f colorZ, float lineWidth) {
        RenderContext ctx = new RenderContext(() -> "malilib:drawBoundingBoxEdges", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_NO_DEPTH_NO_CULL);
        class_287 buffer = ctx.getBuilder();
        RenderUtils.drawBoundingBoxLinesX(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawBoundingBoxEdges(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    private static void drawBoundingBoxLinesX(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesY(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesZ(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderAreaSides(class_2338 pos1, class_2338 pos2, Color4f color, Matrix4f matrix4f) {
        RenderUtils.renderAreaSides(pos1, pos2, color, matrix4f, false);
    }

    public static void renderAreaSides(class_2338 pos1, class_2338 pos2, Color4f color, Matrix4f matrix4f, boolean shouldResort) {
        RenderContext ctx = new RenderContext(() -> "malilib:renderAreaSides", MaLiLibPipelines.POSITION_COLOR_TRANSLUCENT_LEQUAL_DEPTH);
        class_287 buffer = ctx.getBuilder();
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer);
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                if (shouldResort) {
                    ctx.upload(meshData, true);
                    ctx.startResorting(meshData, ctx.createVertexSorter(RenderUtils.camPos()));
                } else {
                    ctx.upload(meshData, false);
                }
                meshData.close();
                ctx.drawPost();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("renderAreaSides(): Draw Exception; {}", (Object)err.getMessage());
        }
    }

    public static void renderAreaSidesBatched(class_2338 pos1, class_2338 pos2, Color4f color, double expand, class_287 buffer) {
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        double minX = (double)Math.min(pos1.method_10263(), pos2.method_10263()) - dx - expand;
        double minY = (double)Math.min(pos1.method_10264(), pos2.method_10264()) - dy - expand;
        double minZ = (double)Math.min(pos1.method_10260(), pos2.method_10260()) - dz - expand;
        double maxX = (double)(Math.max(pos1.method_10263(), pos2.method_10263()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.method_10264(), pos2.method_10264()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.method_10260(), pos2.method_10260()) + 1) - dz + expand;
        RenderUtils.drawBoxAllSidesBatchedQuads((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, color, buffer);
    }

    public static void renderAreaOutlineNoCorners(class_2338 pos1, class_2338 pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ) {
        int end;
        int xMin = Math.min(pos1.method_10263(), pos2.method_10263());
        int yMin = Math.min(pos1.method_10264(), pos2.method_10264());
        int zMin = Math.min(pos1.method_10260(), pos2.method_10260());
        int xMax = Math.max(pos1.method_10263(), pos2.method_10263());
        int yMax = Math.max(pos1.method_10264(), pos2.method_10264());
        int zMax = Math.max(pos1.method_10260(), pos2.method_10260());
        double expand = 0.001;
        class_243 cameraPos = RenderUtils.camPos();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float dxMin = (float)(-dx - 0.001);
        float dyMin = (float)(-dy - 0.001);
        float dzMin = (float)(-dz - 0.001);
        float dxMax = (float)(-dx + 0.001);
        float dyMax = (float)(-dy + 0.001);
        float dzMax = (float)(-dz + 0.001);
        float minX = (float)xMin + dxMin;
        float minY = (float)yMin + dyMin;
        float minZ = (float)zMin + dzMin;
        float maxX = (float)xMax + dxMax;
        float maxY = (float)yMax + dyMax;
        float maxZ = (float)zMax + dzMax;
        RenderContext ctx = new RenderContext(() -> "malilib:renderAreaOutlineNoCorners", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        class_287 buffer = ctx.getBuilder();
        int start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, minY, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, minY, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, maxY + 1.0f, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, maxY + 1.0f, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, minY, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, minY, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, maxY + 1.0f, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, maxY + 1.0f, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(minX, (float)start + dyMin, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(minX, (float)end + dyMax, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, (float)start + dyMin, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(maxX + 1.0f, (float)end + dyMax, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(minX, (float)start + dyMin, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(minX, (float)end + dyMax, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, (float)start + dyMin, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(maxX + 1.0f, (float)end + dyMax, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(minX, minY, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(minX, minY, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, minY, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(maxX + 1.0f, minY, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(minX, maxY + 1.0f, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(minX, maxY + 1.0f, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, maxY + 1.0f, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(maxX + 1.0f, maxY + 1.0f, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        try {
            class_9801 meshData = buffer.method_60794();
            if (meshData != null) {
                ctx.lineWidth(lineWidth);
                ctx.draw(meshData, false, true);
                meshData.close();
            }
            ctx.close();
        }
        catch (Exception err) {
            MaLiLib.LOGGER.error("drawAreaOutlineNoCorners(): Draw Exception; {}", (Object)err.getMessage());
        }
    }
}

