/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.fabrishot.capture;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import me.ramidzkh.fabrishot.config.Config;
import me.ramidzkh.fabrishot.event.ScreenshotSaveCallback;
import net.minecraft.class_1011;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBImageWrite;

public class FramebufferWriter {
    public static void write(class_1011 image, Path file) throws IOException {
        try (FileChannel fc = FileChannel.open(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
             WriteCallback callback = new WriteCallback(fc);){
            switch (Config.CAPTURE_FILE_FORMAT) {
                case PNG: {
                    STBImageWrite.nstbi_write_png_to_func((long)callback.address(), (long)0L, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4318().method_4335(), (long)image.method_67769(), (int)0);
                    break;
                }
                case JPG: {
                    STBImageWrite.nstbi_write_jpg_to_func((long)callback.address(), (long)0L, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4318().method_4335(), (long)image.method_67769(), (int)90);
                    break;
                }
                case TGA: {
                    STBImageWrite.nstbi_write_tga_to_func((long)callback.address(), (long)0L, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4318().method_4335(), (long)image.method_67769());
                    break;
                }
                case BMP: {
                    STBImageWrite.nstbi_write_bmp_to_func((long)callback.address(), (long)0L, (int)image.method_4307(), (int)image.method_4323(), (int)image.method_4318().method_4335(), (long)image.method_67769());
                }
            }
            if (callback.exception != null) {
                throw callback.exception;
            }
        }
        ((ScreenshotSaveCallback)ScreenshotSaveCallback.EVENT.invoker()).onSaved(file);
    }

    private static class WriteCallback
    extends STBIWriteCallback
    implements AutoCloseable,
    Closeable {
        private final WritableByteChannel channel;
        private IOException exception;

        private WriteCallback(WritableByteChannel channel) {
            this.channel = channel;
        }

        public void invoke(long context, long data, int size) {
            if (this.exception != null) {
                return;
            }
            ByteBuffer buf = STBIWriteCallback.getData((long)data, (int)size);
            try {
                this.channel.write(buf);
            }
            catch (IOException e) {
                this.exception = e;
            }
        }

        @Override
        public void close() {
            this.free();
        }
    }
}

