/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.cubeswithoutborders.client;

import dev.kir.cubeswithoutborders.client.FullscreenType;
import dev.kir.cubeswithoutborders.client.util.MacOSUtil;
import dev.kir.cubeswithoutborders.client.util.SystemUtil;
import dev.kir.cubeswithoutborders.client.util.WindowsUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_313;
import net.minecraft.class_319;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public final class FullscreenTypes {
    private static final Map<String, FullscreenType> REGISTRY = new HashMap<String, FullscreenType>();
    public static final FullscreenType DEFAULT = FullscreenTypes.register(new DefaultFullscreen());
    public static final FullscreenType WINDOWED = FullscreenTypes.register(new WindowedFullscreen());
    public static final FullscreenType LINUX_BORDERLESS = FullscreenTypes.register(new LinuxBorderlessFullscreen());
    public static final FullscreenType MAC_OS_BORDERLESS = FullscreenTypes.register(new MacOSBorderlessFullscreen());
    public static final FullscreenType WINDOWS_EXCLUSIVE = FullscreenTypes.register(new WindowsExclusiveFullscreen());
    public static final FullscreenType WINDOWS_BORDERLESS = FullscreenTypes.register(new WindowsBorderlessFullscreen());
    public static final FullscreenType WINDOWS_WINDOWED = FullscreenTypes.register(new WindowsWindowedFullscreen());

    public static FullscreenType validate(FullscreenType fullscreenType) {
        return FullscreenTypes.validate(fullscreenType, DEFAULT);
    }

    public static FullscreenType validate(FullscreenType fullscreenType, FullscreenType defaultFullscreenType) {
        if (fullscreenType == null || !fullscreenType.supported()) {
            return FullscreenTypes.validate(defaultFullscreenType, DEFAULT);
        }
        return fullscreenType;
    }

    public static Optional<FullscreenType> get(String id) {
        String normalizedId = id.trim().toLowerCase(Locale.ROOT);
        return Optional.ofNullable(REGISTRY.get(normalizedId));
    }

    public static Stream<FullscreenType> stream() {
        return REGISTRY.values().stream().filter(FullscreenType::supported).sorted((a, b) -> b.priority() - a.priority());
    }

    public static FullscreenType exclusive() {
        return DEFAULT;
    }

    public static FullscreenType borderless() {
        return FullscreenTypes.stream().findFirst().orElseThrow();
    }

    private static FullscreenType register(FullscreenType fullscreenType) {
        String id = fullscreenType.id().toLowerCase(Locale.ROOT);
        REGISTRY.put(id, fullscreenType);
        return fullscreenType;
    }

    private FullscreenTypes() {
    }

    private static class DefaultFullscreen
    implements FullscreenType {
        private DefaultFullscreen() {
        }

        @Override
        public String id() {
            return "minecraft:default";
        }

        @Override
        public boolean supported() {
            return true;
        }

        @Override
        public int priority() {
            return -1;
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
        }

        @Override
        public void disable(class_1041 window) {
        }
    }

    private static class WindowedFullscreen
    implements FullscreenType {
        private WindowedFullscreen() {
        }

        @Override
        public String id() {
            return "minecraft:windowed";
        }

        @Override
        public boolean supported() {
            return true;
        }

        @Override
        public int priority() {
            return -2;
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            videoMode = monitor.method_1617();
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)0);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669();
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)-1);
        }

        @Override
        public void disable(class_1041 window) {
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
        }
    }

    private static class LinuxBorderlessFullscreen
    implements FullscreenType {
        private LinuxBorderlessFullscreen() {
        }

        @Override
        public String id() {
            return "linux:borderless";
        }

        @Override
        public boolean supported() {
            return SystemUtil.isLinux();
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            videoMode = monitor.method_1617();
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669();
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)monitor.method_1622(), (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)videoMode.method_1671());
        }

        @Override
        public void disable(class_1041 window) {
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
        }
    }

    private static class MacOSBorderlessFullscreen
    implements FullscreenType {
        private MacOSBorderlessFullscreen() {
        }

        @Override
        public String id() {
            return "macos:borderless";
        }

        @Override
        public boolean supported() {
            return SystemUtil.isMacOS();
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            videoMode = monitor.method_1617();
            MacOSUtil.hideGlobalUI();
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)0);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669();
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)-1);
        }

        @Override
        public void disable(class_1041 window) {
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
            MacOSUtil.showGlobalUI();
        }
    }

    private static class WindowsExclusiveFullscreen
    implements FullscreenType {
        private WindowsExclusiveFullscreen() {
        }

        @Override
        public String id() {
            return "windows:exclusive";
        }

        @Override
        public boolean supported() {
            return SystemUtil.isWindows();
        }

        @Override
        public int priority() {
            return 10;
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            videoMode = monitor.method_1617();
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669();
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)-1);
        }

        @Override
        public void disable(class_1041 window) {
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
        }
    }

    private static class WindowsBorderlessFullscreen
    implements FullscreenType {
        private WindowsBorderlessFullscreen() {
        }

        @Override
        public String id() {
            return "windows:borderless";
        }

        @Override
        public boolean supported() {
            return SystemUtil.isWindows();
        }

        @Override
        public int priority() {
            return 100;
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            long hWndInsertAfter = -2L;
            long style = 369229824L;
            long exStyle = 34340880L;
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669();
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)monitor.method_1622(), (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)videoMode.method_1671());
            WindowsUtil.setWindowStyle(window, hWndInsertAfter, style, exStyle);
        }

        @Override
        public void disable(class_1041 window) {
            long hWndInsertAfter = 0L;
            long style = -1777729536L;
            long exStyle = 262160L;
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
            WindowsUtil.setWindowStyle(window, hWndInsertAfter, style, exStyle);
        }
    }

    private static class WindowsWindowedFullscreen
    implements FullscreenType {
        private WindowsWindowedFullscreen() {
        }

        @Override
        public String id() {
            return "windows:windowed";
        }

        @Override
        public boolean supported() {
            return SystemUtil.isWindows();
        }

        @Override
        public int priority() {
            return 1000;
        }

        @Override
        public void enable(class_1041 window, class_313 monitor, class_319 videoMode) {
            videoMode = monitor.method_1617();
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)0);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)0);
            window.field_5183 = monitor.method_1616();
            window.field_5198 = monitor.method_1618();
            window.field_5182 = videoMode.method_1668();
            window.field_5197 = videoMode.method_1669() + 1;
            GLFW.glfwSetWindowMonitor((long)window.method_4490(), (long)0L, (int)window.field_5183, (int)window.field_5198, (int)window.field_5182, (int)window.field_5197, (int)-1);
        }

        @Override
        public void disable(class_1041 window) {
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131077, (int)1);
            GLFW.glfwSetWindowAttrib((long)window.method_4490(), (int)131078, (int)1);
        }
    }
}

