/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.GenericControllerConfig;
import dev.isxander.controlify.screenop.ComponentProcessorProvider;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.compat.vanilla.EditBoxComponentProcessor;
import dev.isxander.controlify.screenop.keyboard.CommonKeyboardHints;
import dev.isxander.controlify.screenop.keyboard.ComponentKeyboardBehaviour;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.LazyComponentDims;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import org.jetbrains.annotations.Nullable;

public class ChatScreenProcessor
extends ScreenProcessor<class_408> {
    private final HoldRepeatHelper suggestionsFwdHoldRepeatHelper = new HoldRepeatHelper(10, 4);
    private final HoldRepeatHelper suggestionsBwdHoldRepeatHelper = new HoldRepeatHelper(10, 4);
    private final Supplier<class_342> inputSupplier;
    private final Supplier<@Nullable KeyboardWidget> keyboardSupplier;
    private final Supplier<@Nullable CmdSuggestionsController> suggestionsController;
    private final LazyComponentDims commandSuggesterHint = new LazyComponentDims((class_2561)class_2561.method_43469((String)"controlify.hint.command_suggester", (Object[])new Object[]{ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.inputGlyph(), ControlifyBindings.GUI_SECONDARY_NAVI_UP.inputGlyph(), ControlifyBindings.GUI_SECONDARY_NAVI_RIGHT.inputGlyph()}));

    public ChatScreenProcessor(class_408 screen, Supplier<class_342> inputSupplier, Supplier<@Nullable KeyboardWidget> keyboardSupplier, Supplier<@Nullable CmdSuggestionsController> suggestionsController) {
        super(screen);
        this.inputSupplier = inputSupplier;
        this.keyboardSupplier = keyboardSupplier;
        this.suggestionsController = suggestionsController;
    }

    @Override
    protected void handleButtons(ControllerEntity controller) {
        super.handleButtons(controller);
        CmdSuggestionsController suggestionsController = this.suggestionsController.get();
        if (suggestionsController != null) {
            if (this.suggestionsFwdHoldRepeatHelper.shouldAction(ControlifyBindings.GUI_SECONDARY_NAVI_DOWN.on(controller)) && suggestionsController.controlify$cycle(1)) {
                this.suggestionsFwdHoldRepeatHelper.onNavigate();
                this.suggestionsBwdHoldRepeatHelper.reset();
                ChatScreenProcessor.playFocusChangeSound();
                this.clearCommandSuggesterHint(controller);
            }
            if (this.suggestionsBwdHoldRepeatHelper.shouldAction(ControlifyBindings.GUI_SECONDARY_NAVI_UP.on(controller)) && suggestionsController.controlify$cycle(-1)) {
                this.suggestionsBwdHoldRepeatHelper.onNavigate();
                this.suggestionsFwdHoldRepeatHelper.reset();
                ChatScreenProcessor.playFocusChangeSound();
                this.clearCommandSuggesterHint(controller);
            }
            if (ControlifyBindings.GUI_SECONDARY_NAVI_RIGHT.on(controller).justPressed() && suggestionsController.controlify$useSuggestion()) {
                this.suggestionsFwdHoldRepeatHelper.reset();
                this.suggestionsBwdHoldRepeatHelper.reset();
                ChatScreenProcessor.playClackSound();
                this.clearCommandSuggesterHint(controller);
            }
        }
    }

    @Override
    protected void render(ControllerEntity controller, class_332 graphics, float tickDelta, Optional<VirtualMouseHandler> vmouse) {
        GenericControllerConfig config = controller.genericConfig().config();
        if (this.keyboardSupplier.get() != null && config.showScreenGuides) {
            CmdSuggestionsController suggestionsController;
            if (config.hintKeyboardCursor) {
                LazyComponentDims hint = CommonKeyboardHints.TEXT_CURSOR;
                int x = this.inputSupplier.get().method_55442() - hint.getWidth() - 2;
                int y = this.inputSupplier.get().method_46427() - hint.getHeight();
                graphics.method_51439(ChatScreenProcessor.minecraft.field_1772, hint.getComponent(), x, y, -1, true);
            }
            if (config.hintKeyboardCommandSuggester && (suggestionsController = this.suggestionsController.get()) != null && suggestionsController.controlify$hasAvailableSuggestions()) {
                LazyComponentDims hint = this.commandSuggesterHint;
                int x = ((class_408)this.screen).field_22789 - hint.getWidth() - 2;
                int n = hint.getHeight();
                Objects.requireNonNull(ChatScreenProcessor.minecraft.field_1772);
                int y = 2 + Math.max(0, n - 9);
                graphics.method_51439(ChatScreenProcessor.minecraft.field_1772, hint.getComponent(), x, y, -1, true);
            }
        }
    }

    @Override
    public void onWidgetRebuild() {
        super.onWidgetRebuild();
        class_342 input = this.inputSupplier.get();
        if (input != null) {
            EditBoxComponentProcessor processor = (EditBoxComponentProcessor)ComponentProcessorProvider.provide((class_364)input);
            processor.setKeyboardBehaviour(new ComponentKeyboardBehaviour.DoNothing());
        }
    }

    private void clearCommandSuggesterHint(ControllerEntity controller) {
        GenericControllerConfig config = controller.genericConfig().config();
        if (config.hintKeyboardCommandSuggester && config.showScreenGuides) {
            config.hintKeyboardCommandSuggester = false;
            Controlify.instance().config().save();
        }
    }

    @Override
    protected HoldRepeatHelper createHoldRepeatHelper() {
        return new HoldRepeatHelper(5, 4);
    }

    public static interface CmdSuggestionsController {
        public boolean controlify$cycle(int var1);

        public boolean controlify$useSuggestion();

        public boolean controlify$hasAvailableSuggestions();
    }
}

