/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.controlling.client;

import com.blamejared.controlling.ControllingConstants;
import com.blamejared.controlling.api.DisplayMode;
import com.blamejared.controlling.api.SortOrder;
import com.blamejared.controlling.api.entries.IKeyEntry;
import com.blamejared.controlling.client.CustomList;
import com.blamejared.controlling.client.DisplayableBoolean;
import com.blamejared.controlling.client.FreeKeysList;
import com.blamejared.controlling.client.NewKeyBindsList;
import com.blamejared.controlling.mixin.AccessAbstractSelectionList;
import com.blamejared.controlling.mixin.AccessKeyBindsScreen;
import com.blamejared.controlling.platform.Services;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_459;
import net.minecraft.class_5244;
import net.minecraft.class_6599;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class NewKeyBindsScreen
extends class_6599 {
    private AutoCompletingEditBox<class_459.class_461> search;
    private DisplayMode displayMode;
    private SortOrder sortOrder = SortOrder.NONE;
    private class_4185 buttonNone;
    private class_4185 buttonConflicting;
    private class_4185 buttonSort;
    private final DisplayableBoolean confirmingReset = new DisplayableBoolean(false, (class_2561)ControllingConstants.COMPONENT_OPTIONS_CONFIRM_RESET, (class_2561)ControllingConstants.COMPONENT_CONTROLS_RESET_ALL);
    private boolean showFree;
    private Supplier<NewKeyBindsList> newKeyList;
    private Supplier<FreeKeysList> freeKeyList;
    private final class_4185.class_4241 PRESS_RESET = btn -> {
        NewKeyBindsScreen screen = this;
        class_310 minecraft = Objects.requireNonNull(screen.field_22787);
        if (!this.confirmingReset.toggle()) {
            for (class_304 keybinding : minecraft.field_1690.field_1839) {
                Services.PLATFORM.setToDefault(minecraft.field_1690, keybinding);
            }
            this.getKeyBindsList().method_49006();
        }
        btn.method_25355(this.confirmingReset.currentDisplay());
    };
    private final class_4185.class_4241 PRESS_NONE = btn -> {
        if (this.displayMode == DisplayMode.NONE) {
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.NONE;
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
        }
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_SORT = btn -> {
        this.sortOrder = this.sortOrder.cycle();
        btn.method_25355(this.sortOrder.getDisplay());
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_CONFLICTING = btn -> {
        if (this.displayMode == DisplayMode.CONFLICTING) {
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS);
            this.displayMode = DisplayMode.ALL;
        } else {
            this.displayMode = DisplayMode.CONFLICTING;
            this.buttonConflicting.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_ALL);
            this.buttonNone.method_25355((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE);
        }
        this.filterKeys();
    };
    private final class_4185.class_4241 PRESS_FREE = btn -> {
        this.method_37066((class_364)this.getKeyBindsList());
        if (this.showFree) {
            this.buttonSort.field_22763 = true;
            this.buttonNone.field_22763 = true;
            this.buttonConflicting.field_22763 = true;
            this.resetButton().field_22763 = this.canReset();
            this.setKeyBindsList(this.newKeyList.get());
        } else {
            this.freeKeyList.get().recalculate();
            this.buttonSort.field_22763 = false;
            this.buttonNone.field_22763 = false;
            this.buttonConflicting.field_22763 = false;
            this.resetButton().field_22763 = false;
            this.setKeyBindsList(this.freeKeyList.get());
        }
        this.filterKeys();
        this.method_37063((class_364)this.getKeyBindsList());
        this.method_25395((class_364)this.getKeyBindsList());
        this.showFree = !this.showFree;
    };

    public NewKeyBindsScreen(class_437 screen, class_315 settings) {
        super(screen, settings);
        this.field_49503.method_48995(48);
        this.field_49503.method_48991(56);
    }

    protected void method_25426() {
        super.method_25426();
        this.search.method_1855(0, false);
    }

    protected void method_57732() {
        int searchX = 340;
        int centerX = this.field_22789 / 2;
        Supplier<List> listSupplier = () -> this.getCustomList().getAllEntries();
        this.search = new AutoCompletingEditBox(this.field_22793, centerX - searchX / 2, 20, searchX, 20, this.search, (class_2561)class_2561.method_43471((String)"selectWorld.search"), ControllingConstants.SEARCHABLE_KEYBINDINGS, listSupplier);
        this.search.addResponder(this::filterKeys);
        class_8667 header = (class_8667)this.field_49503.method_48993((class_8021)class_8667.method_52741(), layoutSettings -> layoutSettings.method_46479(8));
        header.method_52738((class_8021)new class_7842(this.field_22785, this.field_22793), class_7847::method_46467);
        header.method_52738(this.search, layoutSettings -> layoutSettings.method_46479(4));
        this.method_48265((class_364)this.search);
    }

    protected void method_60329() {
        this.newKeyList = Suppliers.memoize(() -> new NewKeyBindsList(this, this.field_22787));
        this.freeKeyList = () -> new FreeKeysList(this, this.field_22787);
        this.getAccess().controlling$setKeyBindsList(this.showFree ? (class_459)this.freeKeyList.get() : (class_459)this.newKeyList.get());
        this.field_49503.method_48999((class_8021)this.getKeyBindsList());
        this.displayMode = DisplayMode.ALL;
    }

    protected void method_31387() {
        int btnWidth = 74;
        this.resetButton(class_4185.method_46430((class_2561)this.confirmingReset.currentDisplay(), (class_4185.class_4241)this.PRESS_RESET).method_46431());
        this.resetButton().field_22763 = this.canReset();
        class_4185 toggleFreeButton = class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_TOGGLE_FREE, (class_4185.class_4241)this.PRESS_FREE).method_46437(btnWidth, 20).method_46431();
        this.buttonSort = class_4185.method_46430((class_2561)this.sortOrder.getDisplay(), (class_4185.class_4241)this.PRESS_SORT).method_46437(btnWidth, 20).method_46431();
        this.buttonNone = class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_NONE, (class_4185.class_4241)this.PRESS_NONE).method_46437(btnWidth, 20).method_46431();
        this.buttonConflicting = class_4185.method_46430((class_2561)ControllingConstants.COMPONENT_OPTIONS_SHOW_CONFLICTS, (class_4185.class_4241)this.PRESS_CONFLICTING).method_46437(btnWidth, 20).method_46431();
        class_7845 grid = (class_7845)this.field_49503.method_48996((class_8021)new class_7845());
        grid.method_48636(4);
        grid.method_48635(8);
        class_7845.class_7939 rowHelper = grid.method_47610(2);
        class_8667 topLeft = (class_8667)rowHelper.method_47612((class_8021)class_8667.method_52742());
        topLeft.method_52735(4);
        topLeft.method_52736((class_8021)toggleFreeButton);
        topLeft.method_52736((class_8021)this.buttonSort);
        class_8667 topRight = (class_8667)rowHelper.method_47612((class_8021)class_8667.method_52742());
        topRight.method_52735(4);
        topRight.method_52736((class_8021)this.buttonNone);
        topRight.method_52736((class_8021)this.buttonConflicting);
        rowHelper.method_47612((class_8021)this.resetButton());
        rowHelper.method_47612((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46431());
    }

    protected void method_48640() {
        super.method_48640();
        this.resetButton().field_22763 = this.canReset();
    }

    public void method_25394(class_332 guiGraphics, int mxPos, int myPos, float partialTicks) {
        super.method_25394(guiGraphics, mxPos, myPos, partialTicks);
        this.search.autoComplete().method_25394(guiGraphics, mxPos, myPos, partialTicks);
    }

    public class_4185 resetButton() {
        return this.getAccess().controlling$getResetButton();
    }

    public void resetButton(class_4185 button) {
        this.getAccess().controlling$setResetButton(button);
    }

    public void filterKeys() {
        this.filterKeys(this.search.method_1882());
    }

    public void filterKeys(String lastSearch) {
        CustomList list = this.getCustomList();
        list.method_25339();
        this.getKeyBindsList().method_44382(0.0);
        if (lastSearch.isEmpty() && this.displayMode == DisplayMode.ALL && this.sortOrder == SortOrder.NONE) {
            for (class_459.class_461 allEntry : this.getCustomList().getAllEntries()) {
                list.addEntryInternal(allEntry);
            }
            return;
        }
        Predicate<class_459.class_461> extraPredicate = entry -> true;
        Consumer<List> postConsumer = entries -> {};
        if (list instanceof NewKeyBindsList) {
            extraPredicate = this.displayMode.getPredicate();
            postConsumer = entries -> {
                entries.removeIf(entry -> !(entry instanceof IKeyEntry));
                list.method_73372(this.sortOrder);
            };
        }
        List entries2 = ControllingConstants.SEARCHABLE_KEYBINDINGS.filterEntries(list.getAllEntries(), lastSearch, extraPredicate);
        for (class_459.class_461 entry2 : entries2) {
            list.addEntryInternal(entry2);
        }
        postConsumer.accept(this.getAbstractSelectionList().controlling$getChildren());
    }

    public boolean method_25402(class_11909 event, boolean doubleClick) {
        boolean b = super.method_25402(event, doubleClick);
        if (!b && this.search.method_25370() && !this.search.autoComplete().method_25402(event, doubleClick)) {
            this.method_25395(null);
            this.method_48267();
            b = true;
        }
        return b;
    }

    public boolean method_25401(double xpos, double ypos, double xDelta, double yDelta) {
        if (this.search.autoComplete().method_25401(xpos, ypos, xDelta, yDelta)) {
            return true;
        }
        return super.method_25401(xpos, ypos, xDelta, yDelta);
    }

    public boolean method_25404(class_11908 event) {
        if (!this.search.method_25370() && this.field_34799 == null && event.method_74240() && event.comp_4795() == 70) {
            this.search.method_25365(true);
            return true;
        }
        if (this.search.method_25370() && event.method_74231()) {
            this.search.method_25365(false);
            return true;
        }
        if (this.field_34799 != null) {
            Services.PLATFORM.handleKeyPress(this, this.field_21336, event);
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_16803(class_11908 event) {
        if (Services.PLATFORM.handleKeyReleased(this, this.field_21336, event)) {
            return true;
        }
        return super.method_16803(event);
    }

    private CustomList getCustomList() {
        class_459 class_4592 = this.getKeyBindsList();
        if (class_4592 instanceof CustomList) {
            CustomList cl = (CustomList)class_4592;
            return cl;
        }
        throw new IllegalStateException("keyBindsList('%s') was not an instance of CustomList! You're either too early or another mod is messing with things.".formatted(this.getKeyBindsList().getClass()));
    }

    public class_459 getKeyBindsList() {
        return this.getAccess().controlling$getKeyBindsList();
    }

    public AccessAbstractSelectionList getAbstractSelectionList() {
        return (AccessAbstractSelectionList)this.getKeyBindsList();
    }

    private void setKeyBindsList(class_459 newList) {
        this.getAccess().controlling$setKeyBindsList(newList);
        this.method_48640();
    }

    private AccessKeyBindsScreen getAccess() {
        return (AccessKeyBindsScreen)((Object)this);
    }

    private boolean canReset() {
        for (class_304 key : this.field_21336.field_1839) {
            if (key.method_1427()) continue;
            return true;
        }
        return false;
    }
}

