/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.api.util.v1;

public final class EasingHelper {
    public static double linear(double d2, double d3, double d4) {
        return d2 + (d3 - d2) * d4;
    }

    public static double inverseLinear(double d2, double d3, double d4) {
        return (d4 - d2) / (d3 - d2);
    }

    public static double out(double d2, double d3) {
        return Math.pow(d2, d3);
    }

    public static double inverseOut(double d2, double d3) {
        return Math.pow(d2, 1.0 / d3);
    }

    public static double out(double d2, double d3, double d4, double d5) {
        return EasingHelper.linear(d2, d3, EasingHelper.out(d4, d5));
    }

    public static double inverseOut(double d2, double d3, double d4, double d5) {
        return EasingHelper.inverseOut(EasingHelper.inverseLinear(d2, d3, d4), d5);
    }

    public static double in(double d2, double d3) {
        return 1.0 - Math.pow(1.0 - d2, d3);
    }

    public static double inverseIn(double d2, double d3) {
        return 1.0 - Math.pow(1.0 - d2, 1.0 / d3);
    }

    public static double in(double d2, double d3, double d4, double d5) {
        return EasingHelper.linear(d2, d3, EasingHelper.in(d4, d5));
    }

    public static double inverseIn(double d2, double d3, double d4, double d5) {
        return EasingHelper.inverseIn(EasingHelper.inverseLinear(d2, d3, d4), d5);
    }

    public static double inOut(double d2, double d3) {
        return (d2 < 0.5 ? EasingHelper.out(d2, d3) : EasingHelper.in(d2, d3)) * Math.pow(2.0, d3 - 1.0);
    }

    public static double inverseInOut(double d2, double d3) {
        if (d2 < 0.5) {
            return Math.pow(d2 / Math.pow(2.0, d3 - 1.0), 1.0 / d3);
        }
        return -Math.pow((1.0 - d2) / Math.pow(2.0, d3 - 1.0), 1.0 / d3) + 1.0;
    }

    public static double inOut(double d2, double d3, double d4, double d5) {
        return EasingHelper.linear(d2, d3, EasingHelper.inOut(d4, d5));
    }

    public static double inverseInOut(double d2, double d3, double d4, double d5) {
        return EasingHelper.inverseInOut(EasingHelper.inverseLinear(d2, d3, d4), d5);
    }
}

