/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.portal;

import com.github.mahmudindev.mcmod.worldportal.WorldPortal;
import com.github.mahmudindev.mcmod.worldportal.config.Config;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalData;
import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class PortalManager {
    private static final Map<ResourceLocation, PortalData> PORTALS = new HashMap<ResourceLocation, PortalData>();

    public static void onResourceManagerReload(ResourceManager manager) {
        PORTALS.clear();
        Config config = Config.getConfig();
        config.getPortals().forEach((id, portal) -> PortalManager.setPortal(ResourceLocation.parse((String)id), portal));
        Gson gson = new Gson();
        manager.listResources("worldportal", resourceLocation -> resourceLocation.getPath().endsWith(".json")).forEach((resourceLocation, resource) -> {
            String resourcePath = resourceLocation.getPath().replaceFirst("^%s/".formatted("worldportal"), "");
            if (!resourcePath.startsWith("portal/")) {
                return;
            }
            try {
                String portalPath = resourcePath.substring(resourcePath.indexOf("/") + 1).replaceAll("\\.json$", "");
                PortalManager.setPortal(resourceLocation.withPath(portalPath), (PortalData)gson.fromJson(JsonParser.parseReader((Reader)resource.openAsReader()), PortalData.class));
            }
            catch (IOException e) {
                WorldPortal.LOGGER.error("Failed to read datapack", (Throwable)e);
            }
        });
    }

    public static Map<ResourceLocation, PortalData> getPortals() {
        return Map.copyOf(PORTALS);
    }

    public static PortalData getPortal(ResourceLocation id) {
        return PORTALS.get(id);
    }

    public static void setPortal(ResourceLocation id, PortalData portal) {
        PORTALS.put(id, portal);
    }
}

