/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.mixin;

import com.github.mahmudindev.mcmod.worldportal.base.IBlockPos;
import com.github.mahmudindev.mcmod.worldportal.core.WorldPortalPoiTypes;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalData;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalManager;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalForcer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PortalForcer.class}, priority=750)
public abstract class PortalForcerLMixin {
    @Shadow
    @Final
    private ServerLevel level;

    @WrapOperation(method={"lambda$findClosestPortalPosition$0(Lnet/minecraft/core/Holder;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/Holder;is(Lnet/minecraft/resources/ResourceKey;)Z")})
    private static boolean method22389IncludePoiType(Holder<PoiType> instance, ResourceKey<PoiType> resourceKey, Operation<Boolean> original) {
        if (instance.is(WorldPortalPoiTypes.END_PORTAL)) {
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, resourceKey});
    }

    @WrapOperation(method={"findClosestPortalPosition(Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Ljava/util/stream/Stream;filter(Ljava/util/function/Predicate;)Ljava/util/stream/Stream;", ordinal=0)})
    private Stream<BlockPos> findClosestPortalPositionFilter(Stream<BlockPos> instance, Predicate<? super BlockPos> predicate, Operation<Stream<BlockPos>> original, BlockPos blockPos) {
        HashMap blockPosPassMap = new HashMap();
        PortalData portal = ((IBlockPos)blockPos).worldportal$getPortal();
        Level level = ((IBlockPos)blockPos).worldportal$getLevel();
        boolean hasHA = level == null || level.getBlockState(((IBlockPos)blockPos).worldportal$getPortalEntrancePos()).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
        return ((Stream)original.call(new Object[]{instance, predicate})).filter(blockPosX -> {
            Boolean blockPosPass = (Boolean)blockPosPassMap.get(blockPosX);
            if (blockPosPass != null) {
                return blockPosPass;
            }
            Direction.Axis AxisX = Direction.Axis.X;
            Direction.Axis AxisY = Direction.Axis.Y;
            Direction.Axis AxisZ = Direction.Axis.Z;
            BlockState blockState = this.level.getBlockState(blockPosX);
            boolean hasHAX = blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
            Direction.Axis axis = hasHAX ? (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) : AxisX;
            BlockUtil.FoundRectangle foundRectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockPosX, (Direction.Axis)axis, (int)21, (Direction.Axis)(hasHAX ? AxisY : AxisZ), (int)21, blockPosZ -> this.level.getBlockState(blockPosZ) == blockState);
            ResourceLocation frameC1 = BuiltInRegistries.BLOCK.getKey((Object)this.level.getBlockState(foundRectangle.minCorner.offset(axis == AxisX ? foundRectangle.axis1Size : 0, hasHAX ? -1 : 0, hasHAX ? (axis == AxisZ ? foundRectangle.axis1Size : 0) : -1)).getBlock());
            ResourceLocation frameC2 = BuiltInRegistries.BLOCK.getKey((Object)this.level.getBlockState(foundRectangle.minCorner.offset(axis == AxisX ? -1 : 0, hasHAX ? -1 : 0, hasHAX && axis != AxisZ ? 0 : -1)).getBlock());
            ResourceLocation frameC3 = BuiltInRegistries.BLOCK.getKey((Object)this.level.getBlockState(foundRectangle.minCorner.offset(axis == AxisX ? foundRectangle.axis1Size : 0, hasHAX ? foundRectangle.axis2Size : 0, hasHAX ? (axis == AxisZ ? foundRectangle.axis1Size : 0) : foundRectangle.axis2Size)).getBlock());
            ResourceLocation frameC4 = BuiltInRegistries.BLOCK.getKey((Object)this.level.getBlockState(foundRectangle.minCorner.offset(axis == AxisX ? -1 : 0, hasHAX ? foundRectangle.axis2Size : 0, hasHAX ? (axis == AxisZ ? -1 : 0) : foundRectangle.axis2Size)).getBlock());
            boolean blockPosPassX = false;
            if (portal != null) {
                boolean bl = blockPosPassX = hasHA == hasHAX;
                if (blockPosPassX) {
                    for (ResourceLocation[] v : new ResourceLocation[][]{{frameC1, portal.getFrameBottomLeftLocation()}, {frameC2, portal.getFrameBottomRightLocation()}, {frameC3, portal.getFrameTopLeftLocation()}, {frameC4, portal.getFrameTopRightLocation()}}) {
                        if (v[1] != null && v[0].equals((Object)v[1])) continue;
                        blockPosPassX = false;
                        break;
                    }
                }
            } else if (hasHAX) {
                blockPosPassX = true;
                Map<ResourceLocation, PortalData> portals = PortalManager.getPortals();
                for (Map.Entry<ResourceLocation, PortalData> entry : portals.entrySet()) {
                    ResourceLocation c4;
                    ResourceLocation c3;
                    ResourceLocation c2;
                    ResourceLocation c1;
                    PortalData portalX = entry.getValue();
                    ResourceLocation mode = portalX.getModeLocation();
                    if (mode != null && !mode.equals((Object)PortalData.DEFAULT_MODE) || (c1 = portalX.getFrameBottomLeftLocation()) != null && !c1.equals((Object)frameC1) || (c2 = portalX.getFrameBottomRightLocation()) != null && !c2.equals((Object)frameC2) || (c3 = portalX.getFrameTopLeftLocation()) != null && !c3.equals((Object)frameC3) || (c4 = portalX.getFrameTopRightLocation()) != null && !c4.equals((Object)frameC4)) continue;
                    blockPosPassX = false;
                    break;
                }
            }
            for (int i = 0; i < foundRectangle.axis1Size; ++i) {
                for (int j = 0; j < foundRectangle.axis2Size; ++j) {
                    blockPosPassMap.put(foundRectangle.minCorner.offset(axis == AxisX ? i : 0, hasHAX ? j : 0, hasHAX ? (axis == AxisZ ? i : 0) : j), blockPosPassX);
                }
            }
            return blockPosPassX;
        });
    }

    @WrapOperation(method={"lambda$findClosestPortalPosition$1(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;hasProperty(Lnet/minecraft/world/level/block/state/properties/Property;)Z")})
    private boolean method31119HasPropertySkip(BlockState instance, Property<?> property, Operation<Boolean> original) {
        return true;
    }

    @WrapMethod(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"})
    private Optional<BlockUtil.FoundRectangle> createPortalProcess(BlockPos blockPos, Direction.Axis axis, Operation<Optional<BlockUtil.FoundRectangle>> original, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        Level level = ((IBlockPos)blockPos).worldportal$getLevel();
        boolean hasHA = level == null || level.getBlockState(((IBlockPos)blockPos).worldportal$getPortalEntrancePos()).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS);
        hasHARef.set(hasHA);
        Optional optional = (Optional)original.call(new Object[]{blockPos, axis});
        if (optional.isEmpty()) {
            return optional;
        }
        PortalData portal = ((IBlockPos)blockPos).worldportal$getPortal();
        if (portal != null) {
            ResourceLocation frameC4;
            ResourceLocation frameC3;
            ResourceLocation frameC2;
            BlockUtil.FoundRectangle foundRectangle = (BlockUtil.FoundRectangle)optional.get();
            Direction.Axis AxisX = Direction.Axis.X;
            Direction.Axis AxisZ = Direction.Axis.Z;
            ResourceLocation frameC1 = portal.getFrameBottomLeftLocation();
            if (frameC1 != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(frameC1);
                this.level.setBlockAndUpdate(foundRectangle.minCorner.offset(axis == AxisX ? foundRectangle.axis1Size : 0, hasHA ? -1 : 0, hasHA ? (axis == AxisZ ? foundRectangle.axis1Size : 0) : -1), block.defaultBlockState());
            }
            if ((frameC2 = portal.getFrameBottomRightLocation()) != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(frameC2);
                this.level.setBlockAndUpdate(foundRectangle.minCorner.offset(axis == AxisX ? -1 : 0, hasHA ? -1 : 0, hasHA && axis != AxisZ ? 0 : -1), block.defaultBlockState());
            }
            if ((frameC3 = portal.getFrameTopLeftLocation()) != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(frameC3);
                this.level.setBlockAndUpdate(foundRectangle.minCorner.offset(axis == AxisX ? foundRectangle.axis1Size : 0, hasHA ? foundRectangle.axis2Size : 0, hasHA ? (axis == AxisZ ? foundRectangle.axis1Size : 0) : foundRectangle.axis2Size), block.defaultBlockState());
            }
            if ((frameC4 = portal.getFrameTopRightLocation()) != null) {
                Block block = (Block)BuiltInRegistries.BLOCK.get(frameC4);
                this.level.setBlockAndUpdate(foundRectangle.minCorner.offset(axis == AxisX ? -1 : 0, hasHA ? foundRectangle.axis2Size : 0, hasHA ? (axis == AxisZ ? -1 : 0) : foundRectangle.axis2Size), block.defaultBlockState());
            }
        }
        return optional;
    }

    @WrapOperation(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;setWithOffset(Lnet/minecraft/core/Vec3i;III)Lnet/minecraft/core/BlockPos$MutableBlockPos;", ordinal=0)})
    private BlockPos.MutableBlockPos createPortalSupport(BlockPos.MutableBlockPos instance, Vec3i vec3i, int i, int j, int k, Operation<BlockPos.MutableBlockPos> original, BlockPos blockPos, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        return (BlockPos.MutableBlockPos)original.call(new Object[]{instance, vec3i, i, j, hasHARef.get() ? k : k + 1});
    }

    @WrapOperation(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;setWithOffset(Lnet/minecraft/core/Vec3i;III)Lnet/minecraft/core/BlockPos$MutableBlockPos;", ordinal=1)})
    private BlockPos.MutableBlockPos createPortalFrame(BlockPos.MutableBlockPos instance, Vec3i vec3i, int i, int j, int k, Operation<BlockPos.MutableBlockPos> original, BlockPos blockPos, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        boolean hasHA = hasHARef.get();
        return (BlockPos.MutableBlockPos)original.call(new Object[]{instance, vec3i, i, hasHA ? j : 0, hasHA ? k : j});
    }

    @ModifyExpressionValue(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/block/Blocks;NETHER_PORTAL:Lnet/minecraft/world/level/block/Block;")})
    private Block createPortalBlock(Block original, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        return hasHARef.get() ? original : Blocks.END_PORTAL;
    }

    @WrapOperation(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;setValue(Lnet/minecraft/world/level/block/state/properties/Property;Ljava/lang/Comparable;)Ljava/lang/Object;")})
    private Object createPortalSetPropertySkip(BlockState instance, Property<?> property, Comparable<?> comparable, Operation<Object> original, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        return hasHARef.get() ? original.call(new Object[]{instance, property, comparable}) : instance;
    }

    @WrapOperation(method={"createPortal(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;setWithOffset(Lnet/minecraft/core/Vec3i;III)Lnet/minecraft/core/BlockPos$MutableBlockPos;", ordinal=2)})
    private BlockPos.MutableBlockPos createPortalBlock(BlockPos.MutableBlockPos instance, Vec3i vec3i, int i, int j, int k, Operation<BlockPos.MutableBlockPos> original, BlockPos blockPos, @Share(namespace="worldportal", value="hasHA") LocalBooleanRef hasHARef) {
        boolean hasHA = hasHARef.get();
        return (BlockPos.MutableBlockPos)original.call(new Object[]{instance, vec3i, i, hasHA ? j : 0, hasHA ? k : j});
    }
}

