/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.mixin;

import com.github.mahmudindev.mcmod.worldportal.portal.PortalData;
import com.github.mahmudindev.mcmod.worldportal.portal.PortalManager;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BaseFireBlock.class})
public abstract class BaseFireBlockMixin {
    @Inject(method={"onPlace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canSurvive(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z")})
    private void onPlaceHorizontalPortal(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl, CallbackInfo ci) {
        int x;
        boolean inPortalDimension = false;
        Map<ResourceLocation, PortalData> portals = PortalManager.getPortals();
        for (Map.Entry<ResourceLocation, PortalData> entry : portals.entrySet()) {
            if (inPortalDimension) break;
            PortalData portal = entry.getValue();
            ResourceLocation mode = portal.getModeLocation();
            if (mode == null || !mode.equals((Object)PortalData.HORIZONTAL_MODE) || portal.getDestinationKey() == level.dimension()) continue;
            inPortalDimension = true;
        }
        Function<BlockState, Boolean> isEmpty = blockStateX -> {
            if (blockStateX.isAir() || blockStateX.is(BlockTags.FIRE)) {
                return true;
            }
            return blockStateX.is(Blocks.END_PORTAL);
        };
        if (!inPortalDimension || !isEmpty.apply(blockState).booleanValue()) {
            return;
        }
        BlockPos blockPosX = blockPos;
        while (true) {
            if (Math.abs(blockPos.getX() - blockPosX.getX()) > 21) {
                return;
            }
            if (Math.abs(blockPos.getZ() - blockPosX.getZ()) > 21) {
                return;
            }
            BlockPos blockPosH = blockPosX.north();
            BlockState blockStateN = level.getBlockState(blockPosH);
            if (!isEmpty.apply(blockStateN).booleanValue()) {
                if (!blockStateN.is(Blocks.OBSIDIAN)) {
                    return;
                }
                blockPosH = blockPosX.west();
                BlockState blockStateW = level.getBlockState(blockPosH);
                if (!isEmpty.apply(blockStateW).booleanValue()) {
                    if (blockStateW.is(Blocks.OBSIDIAN)) break;
                    return;
                }
            }
            blockPosX = blockPosH;
        }
        int distanceS = 1;
        for (int i = 1; i <= 21; ++i) {
            BlockPos blockPosS = blockPosX.south(i);
            BlockState blockStateS = level.getBlockState(blockPosS);
            if (!isEmpty.apply(blockStateS).booleanValue()) {
                if (blockStateS.is(Blocks.OBSIDIAN)) break;
                return;
            }
            if (!level.getBlockState(blockPosS.west()).is(Blocks.OBSIDIAN)) {
                return;
            }
            ++distanceS;
        }
        int distanceE = 1;
        for (int i = 1; i <= 21; ++i) {
            BlockPos blockPosE = blockPosX.east(i);
            BlockState blockStateE = level.getBlockState(blockPosE);
            if (!isEmpty.apply(blockStateE).booleanValue()) {
                if (blockStateE.is(Blocks.OBSIDIAN)) break;
                return;
            }
            if (!level.getBlockState(blockPosE.north()).is(Blocks.OBSIDIAN)) {
                return;
            }
            ++distanceE;
        }
        if (distanceS < 3 && distanceE < 2 || distanceS < 2 && distanceE < 3) {
            return;
        }
        for (x = 1; x < distanceE; ++x) {
            for (int z = 1; z < distanceS; ++z) {
                BlockPos blockPosH = blockPosX.offset(x, 0, z);
                if (x == distanceE - 1 && !level.getBlockState(blockPosH.east()).is(Blocks.OBSIDIAN)) {
                    return;
                }
                if (z == distanceS - 1 && !level.getBlockState(blockPosH.south()).is(Blocks.OBSIDIAN)) {
                    return;
                }
                if (isEmpty.apply(level.getBlockState(blockPosH)).booleanValue()) continue;
                return;
            }
        }
        for (x = 0; x < distanceE; ++x) {
            for (int z = 0; z < distanceS; ++z) {
                level.setBlock(blockPosX.offset(x, 0, z), Blocks.END_PORTAL.defaultBlockState(), 18);
            }
        }
    }
}

