/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import de.maxhenkel.speex4j.AutomaticGainControl;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.natives.NativeUtils;
import de.maxhenkel.voicechat.natives.NativeValidator;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import javax.annotation.Nullable;

public class SpeexManager
extends NativeValidator {
    public static final int TARGET = AudioUtils.dbSample(-5.0);
    private static SpeexManager instance;

    @Override
    protected void runValidation() throws Throwable {
        try (AutomaticGainControl agc = new AutomaticGainControl(960, 48000);){
            agc.setTarget(TARGET);
            agc.agc(new short[960]);
        }
    }

    @Override
    protected String getNativeName() {
        return "Speex";
    }

    @Nullable
    public static AutomaticGainControl createAgc() {
        SpeexManager instance = SpeexManager.instance();
        if (!instance.canUse()) {
            return null;
        }
        return NativeUtils.createSafe(() -> {
            AutomaticGainControl agc = new AutomaticGainControl(960, 48000);
            agc.setTarget(TARGET);
            return agc;
        }, e -> {
            instance.setFailed(e.getMessage());
            Voicechat.LOGGER.warn("Failed to load Speex", e);
        });
    }

    public static boolean canUseAgc() {
        return SpeexManager.instance().canUse();
    }

    public static void init() {
        SpeexManager.instance().initialize();
    }

    public static boolean isFailed() {
        return !SpeexManager.instance().canUse();
    }

    public static String getFailedMessage() {
        return SpeexManager.instance().getMessage();
    }

    private static synchronized SpeexManager instance() {
        if (instance == null) {
            instance = new SpeexManager();
        }
        return instance;
    }
}

