/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import de.maxhenkel.lame4j.Mp3Decoder;
import de.maxhenkel.lame4j.Mp3Encoder;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.natives.NativeUtils;
import de.maxhenkel.voicechat.natives.NativeValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;

public class LameManager
extends NativeValidator {
    private static LameManager instance;

    @Override
    protected void runValidation() throws Throwable {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            try (Mp3Encoder encoder = new Mp3Encoder(1, 48000, 128, 5, byteArrayOutputStream);){
                encoder.write(new short[960]);
            }
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                 Mp3Decoder decoder = new Mp3Decoder(byteArrayInputStream);){
                decoder.decodeNextFrame();
                decoder.getSampleRate();
                decoder.getBitRate();
                decoder.getChannelCount();
            }
        }
    }

    @Override
    protected String getNativeName() {
        return "LAME";
    }

    @Nullable
    public static Mp3Encoder createEncoder(AudioFormat audioFormat, int bitrate, int quality, OutputStream outputStream) {
        LameManager instance = LameManager.instance();
        if (!instance.canUse()) {
            return null;
        }
        return NativeUtils.createSafe(() -> new Mp3Encoder(audioFormat.getChannels(), (int)audioFormat.getSampleRate(), bitrate, quality, outputStream), e -> {
            instance.setFailed(e.getMessage());
            Voicechat.LOGGER.warn("Failed to load LAME encoder", e);
        });
    }

    @Nullable
    public static Mp3Decoder createDecoder(InputStream inputStream) {
        LameManager instance = LameManager.instance();
        if (!instance.canUse()) {
            return null;
        }
        return NativeUtils.createSafe(() -> new Mp3Decoder(inputStream), e -> {
            instance.setFailed(e.getMessage());
            Voicechat.LOGGER.warn("Failed to load LAME decoder", e);
        });
    }

    public static boolean canUseLame() {
        return LameManager.instance().canUse();
    }

    public static void init() {
        LameManager.instance().initialize();
    }

    public static boolean isFailed() {
        return !LameManager.instance().canUse();
    }

    public static String getFailedMessage() {
        return LameManager.instance().getMessage();
    }

    private static synchronized LameManager instance() {
        if (instance == null) {
            instance = new LameManager();
        }
        return instance;
    }
}

