/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FilterSlotItemHandler
extends SlotItemHandler {
    protected final UpgradeBase upgrade;
    protected final int activeSlotCount;

    public FilterSlotItemHandler(UpgradeBase upgrade, IItemHandler itemHandler, int index, int xPosition, int yPosition, int activeSlotCount) {
        super(itemHandler, index, xPosition, yPosition);
        this.upgrade = upgrade;
        this.activeSlotCount = activeSlotCount;
    }

    public boolean isActive() {
        return this.upgrade.isTabOpened() && this.index < this.activeSlotCount;
    }

    public boolean mayPlace(ItemStack pStack) {
        return this.upgrade.isTabOpened() && this.index < this.activeSlotCount && super.mayPlace(pStack);
    }

    public boolean isFake() {
        return true;
    }

    public boolean mayPickup(Player player) {
        return this.upgrade.getUpgradeManager().getWrapper().isOwner(player) && this.index < this.activeSlotCount;
    }

    public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
        if (!this.mayPickup(player)) {
            return Optional.empty();
        }
        this.set(ItemStack.EMPTY);
        return Optional.empty();
    }

    public ItemStack safeInsert(ItemStack stack, int increment) {
        if (!stack.isEmpty() && this.mayPlace(stack)) {
            this.set(stack.copyWithCount(1));
        }
        return stack;
    }
}

