/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.foundation;

import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;

public class MerchantOfferInfo {
    final ItemStack costA;
    final ItemStack costB;
    final ItemStack result;

    public MerchantOfferInfo(MerchantOffer offer) {
        this.costA = offer.getBaseCostA();
        this.costB = offer.getCostB();
        this.result = offer.getResult();
    }

    public MerchantOfferInfo(ItemStack costA, ItemStack costB, ItemStack result) {
        this.costA = costA;
        this.costB = costB;
        this.result = result;
    }

    protected MerchantOfferInfo(HolderLookup.Provider registryAccess, CompoundTag tag) {
        this.costA = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound("CostA"));
        this.costB = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound("CostB"));
        this.result = ItemStack.parseOptional((HolderLookup.Provider)registryAccess, (CompoundTag)tag.getCompound("Result"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MerchantOfferInfo)) {
            return false;
        }
        MerchantOfferInfo that = (MerchantOfferInfo)o;
        return ItemStack.isSameItemSameComponents((ItemStack)this.costA, (ItemStack)that.costA) && ItemStack.isSameItemSameComponents((ItemStack)this.costB, (ItemStack)that.costB) && ItemStack.isSameItemSameComponents((ItemStack)this.result, (ItemStack)that.result);
    }

    public int hashCode() {
        return Objects.hash(this.costA, this.costB, this.result);
    }

    public static MerchantOfferInfo read(HolderLookup.Provider provider, CompoundTag tag) {
        return new MerchantOfferInfo(provider, tag);
    }

    public Tag write(HolderLookup.Provider registryAccess, CompoundTag tag) {
        tag.put("CostA", this.costA.saveOptional(registryAccess));
        tag.put("CostB", this.costB.saveOptional(registryAccess));
        tag.put("Result", this.result.saveOptional(registryAccess));
        return tag;
    }

    public ItemStack getCostA() {
        return this.costA;
    }

    public ItemStack getCostB() {
        return this.costB;
    }

    public ItemStack getResult() {
        return this.result;
    }
}

