/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.mojang.serialization.Codec;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.common.blocks.entities.machines.AntennaBlockEntity;
import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.data.recipes.SpaceStationRecipe;
import com.st0x0ef.stellaris.common.data_components.SpaceSuitModules;
import com.st0x0ef.stellaris.common.entities.vehicles.LanderEntity;
import com.st0x0ef.stellaris.common.entities.vehicles.RocketEntity;
import com.st0x0ef.stellaris.common.launchpads.LaunchPad;
import com.st0x0ef.stellaris.common.registry.BlocksRegistry;
import com.st0x0ef.stellaris.common.registry.DataComponentsRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.StatsRegistry;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import com.st0x0ef.stellaris.common.utils.TeleportUtil;
import com.st0x0ef.stellaris.common.vehicle_upgrade.FuelType;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void transfertInventory(RocketEntity rocket, LanderEntity lander) {
        Container rocketContainer = rocket.getInventory();
        Container landerContainer = lander.getInventory();
        for (int i = 2; i < lander.getInventory().getContainerSize() - 1; ++i) {
            landerContainer.setItem(i, rocketContainer.getItem(i));
        }
        ItemStack rocketStack = new ItemStack((ItemLike)ItemsRegistry.ROCKET.get());
        rocketStack.set((DataComponentType)DataComponentsRegistry.ROCKET_COMPONENT.get(), (Object)rocket.getRocketComponent());
        landerContainer.setItem(14, rocketStack);
    }

    public static LanderEntity createLanderFromRocket(RocketEntity rocket, Vec3 coords, Level destination) {
        LanderEntity lander = new LanderEntity(destination);
        Vec3 landerOffset = new Vec3(0.5, 0.0, -0.5);
        lander.setPos(coords.x + landerOffset.x, coords.y, coords.z + landerOffset.z);
        Utils.transfertInventory(rocket, lander);
        rocket.discard();
        return lander;
    }

    public static void teleportEntity(Entity entity, Planet destination, Vec3 coords) {
        if (entity.level().isClientSide()) {
            return;
        }
        entity.setNoGravity(false);
        TeleportUtil.teleportToPlanet(entity, Utils.getPlanetLevel(destination), coords);
    }

    public static void changeDimension(Player player, Planet destination) {
        Utils.changeDimension(player, destination, new Vec3((double)((int)player.getX()), (double)Stellaris.CONFIG.rocketTpHeight, (double)((int)player.getZ())));
    }

    public static void changeDimension(Player player, Planet destination, Vec3 coords) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Entity entity = serverPlayer.getVehicle();
            if (entity instanceof RocketEntity) {
                RocketEntity rocket = (RocketEntity)entity;
                serverPlayer.stopRiding();
                serverPlayer.closeContainer();
                if (!serverPlayer.isCreative() && !serverPlayer.isSpectator()) {
                    int fuelConsumption = Math.round(FuelType.getFuelNeededToGoOnPlanet(PlanetUtil.getPlanet(serverPlayer.level().dimension().location()), destination, rocket.FUEL_TYPE));
                    rocket.FUEL -= fuelConsumption;
                    rocket.syncRocketData(serverPlayer);
                }
                LanderEntity lander = Utils.createLanderFromRocket(rocket, coords, (Level)Utils.getPlanetLevel(destination));
                Utils.teleportEntity((Entity)serverPlayer, destination, lander.getPassengerRidingPosition((Entity)serverPlayer));
                player.awardStat((ResourceLocation)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.level().dimension().location()), destination));
                serverPlayer.level().addFreshEntity((Entity)lander);
                while (!serverPlayer.startRiding((Entity)lander, true)) {
                }
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.stellaris.lander"));
            } else {
                serverPlayer.closeContainer();
                Utils.teleportEntity((Entity)serverPlayer, destination, coords);
            }
        }
    }

    public static void changeDimensionWithVehicle(Entity entity, Planet destination, Vec3 coords) {
        Entity vehicle = entity.getVehicle();
        entity.stopRiding();
        Utils.teleportEntity(entity, destination, coords);
        if (vehicle != null) {
            Utils.teleportEntity(vehicle, destination, coords);
            entity.startRiding(vehicle, true);
        }
    }

    public static void changeDimensionForPlayers(List<Entity> entities, Planet destination, Vec3 coords, boolean setHeight) {
        if (setHeight) {
            coords = new Vec3(coords.x, (double)Stellaris.CONFIG.rocketTpHeight, coords.z);
        }
        Utils.changeDimensionForPlayers(entities, destination, coords);
    }

    public static void changeDimensionForPlayers(List<Entity> entities, Planet destination, Vec3 coords) {
        RocketEntity rocket = (RocketEntity)entities.getFirst().getVehicle();
        for (Entity entity : entities) {
            if (entity.level().isClientSide()) {
                return;
            }
            Entity vehicle = entity.getVehicle();
            if (!(vehicle instanceof RocketEntity)) continue;
            RocketEntity playerRocket = (RocketEntity)vehicle;
            entity.stopRiding();
            rocket = playerRocket;
            Utils.teleportEntity(entity, destination, coords);
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            player.awardStat((ResourceLocation)StatsRegistry.SPACE_TRAVEL.get(), Utils.distanceToPlanet(PlanetUtil.getPlanet(player.level().dimension().location()), destination));
            player.closeContainer();
            player.stellaris$setPlanetMenuOpen(false, player, true);
        }
        LanderEntity lander = Utils.createLanderFromRocket(rocket, coords, (Level)Utils.getPlanetLevel(destination));
        entities.getFirst().level().addFreshEntity((Entity)lander);
        for (Entity entity : entities) {
            entity.startRiding((Entity)lander, true);
            entity.sendSystemMessage((Component)Component.translatable((String)"message.stellaris.lander"));
        }
    }

    public static int distanceToPlanet(Planet actual, Planet destination) {
        return Mth.abs((int)(actual.distanceFromEarth() - destination.distanceFromEarth()));
    }

    public static double changeLastDigitToEven(double number) {
        Object numberStr = Double.toString(number);
        int decimalIndex = ((String)numberStr).indexOf(46);
        if (decimalIndex != -1) {
            String beforeDecimal = ((String)numberStr).substring(0, decimalIndex + 1);
            Object afterDecimal = ((String)numberStr).substring(decimalIndex + 1);
            char lastChar = ((String)afterDecimal).charAt(((String)afterDecimal).length() - 1);
            if ((lastChar - 48) % 2 != 0) {
                afterDecimal = ((String)afterDecimal).substring(0, ((String)afterDecimal).length() - 1) + "2";
            }
            numberStr = beforeDecimal + (String)afterDecimal;
        }
        return Double.parseDouble((String)numberStr);
    }

    public static int getColorHexCode(String colorName) {
        if (colorName.startsWith("#")) {
            try {
                return Integer.parseInt(colorName.substring(1), 16);
            }
            catch (NumberFormatException e) {
                return 0xFFFFFF;
            }
        }
        return switch (colorName.toLowerCase()) {
            case "black" -> 0;
            case "red" -> 0xFF0000;
            case "green" -> 32768;
            case "blue" -> 255;
            case "yellow" -> 0xFFFF00;
            case "cyan" -> 65535;
            case "magenta" -> 0xFF00FF;
            case "gray", "grey" -> 0x808080;
            case "maroon" -> 0x800000;
            case "olive" -> 0x808000;
            case "purple" -> 0x800080;
            case "teal" -> 32896;
            case "navy" -> 128;
            case "orange" -> 16753920;
            case "brown" -> 0xA52A2A;
            case "lime" -> 65280;
            case "pink" -> 16761035;
            case "coral" -> 16744272;
            case "gold" -> 16766720;
            case "silver" -> 0xC0C0C0;
            case "beige" -> 16119260;
            case "lavender" -> 15132410;
            case "turquoise" -> 4251856;
            case "salmon" -> 16416882;
            case "khaki" -> 15787660;
            case "darkred" -> 0x8B0000;
            case "dark_red" -> 0x8B0000;
            case "rainbow" -> Utils.generateRandomHexColor();
            default -> 0xFFFFFF;
        };
    }

    public static int generateRandomHexColor() {
        Random random = new Random();
        return random.nextInt(0x1000000);
    }

    public static String betterIntToString(int i) {
        if (i == 0) {
            return "0";
        }
        return i % 1000 + "K";
    }

    public static Component getMessageComponent(String text, String color) {
        return Component.literal((String)text).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)Utils.getColorHexCode(color))));
    }

    public static Component getMessageComponent(String text, int color) {
        return Component.literal((String)text).setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)color)));
    }

    public static Component getMessageComponent(String text) {
        return Component.literal((String)text).setStyle(Style.EMPTY);
    }

    public static int getPlayerCountInDimension(MinecraftServer server, ResourceLocation dimensionKey) {
        ServerLevel dimension = server.getLevel(Utils.getPlanetLevel(dimensionKey));
        if (dimension == null) {
            return 0;
        }
        return dimension.players().size();
    }

    public static <T extends Enum<T>> Codec<T> EnumCodec(Class<T> e) {
        Function<String, Enum> stringToEnum = s -> Enum.valueOf(e, s.toUpperCase(Locale.ROOT));
        Function<Enum, String> enumToString = Enum::name;
        return Codec.STRING.xmap(stringToEnum, enumToString);
    }

    public static float MCGToMPS2(float MCG) {
        return 122.58312f * MCG;
    }

    public static double MPS2ToMCG(float MPS2) {
        if (MPS2 > 0.0f) {
            return Math.floor(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        if (MPS2 < 0.0f) {
            return Math.ceil(0.00816 * (double)MPS2 * 100000.0) / 100000.0;
        }
        return 0.0;
    }

    public static void disableFlyAntiCheat(Player player, boolean condition) {
        if (player instanceof ServerPlayer && condition) {
            ((ServerPlayer)player).connection.aboveGroundTickCount = 0;
        }
    }

    public static boolean isLivingInJetSuit(LivingEntity entity) {
        return Utils.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.JETSUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.JETSUIT_HELMET.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.JETSUIT_SUIT.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.JETSUIT_LEGGINGS.get());
    }

    public static boolean isLivingInSpaceSuit(LivingEntity entity) {
        return Utils.isLivingInArmor(entity, EquipmentSlot.FEET, (Item)ItemsRegistry.SPACESUIT_BOOTS.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.LEGS, (Item)ItemsRegistry.SPACESUIT_LEGGINGS.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.CHEST, (Item)ItemsRegistry.SPACESUIT_SUIT.get()) && Utils.isLivingInArmor(entity, EquipmentSlot.HEAD, (Item)ItemsRegistry.SPACESUIT_HELMET.get());
    }

    public static boolean isLivingInArmor(LivingEntity entity, EquipmentSlot slot, Item item) {
        return entity.getItemBySlot(slot).getItem() == item;
    }

    public static ResourceKey<Level> getPlanetLevel(ResourceLocation planet) {
        return ResourceKey.create((ResourceKey)ResourceKey.createRegistryKey((ResourceLocation)planet), (ResourceLocation)planet);
    }

    public static ServerLevel getPlanetLevel(Planet planet) {
        for (ServerLevel level : GameInstance.getServer().getAllLevels()) {
            if (!level.dimension().location().equals((Object)planet.dimension())) continue;
            return level;
        }
        return null;
    }

    public static boolean entityHasBlockAbove(LivingEntity entity, @Nullable BlockPos pos, @Nullable Integer recusion) {
        return entity.level().canSeeSky(entity.blockPosition());
    }

    public static BlockPos getBlockPosFromVector3i(Vec3 vec3) {
        return new BlockPos((int)vec3.x, (int)vec3.y, (int)vec3.z);
    }

    public <T> void addButtonToList(ArrayList<ArrayList<T>> finalList, T button, int size) {
        if (finalList.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            return;
        }
        for (ArrayList<T> buttons : finalList) {
            if (buttons.size() < size) {
                buttons.add(button);
                break;
            }
            if (buttons.size() != size || finalList.indexOf(buttons) + 1 < finalList.size()) continue;
            ArrayList<T> list = new ArrayList<T>();
            list.add(button);
            finalList.add(list);
            break;
        }
    }

    public static Vec3 placeSpaceStation(Player player, ServerLevel serverLevel, SpaceStationRecipe recipe, LaunchPad pad) {
        StructureTemplate structureTemplate = serverLevel.getStructureManager().getOrCreate(recipe.location());
        BlockPos pos = new BlockPos((int)player.getX() - structureTemplate.getSize().getX() / 2, 100, (int)player.getZ() - structureTemplate.getSize().getZ() / 2);
        structureTemplate.placeInWorld((ServerLevelAccessor)serverLevel, pos, pos, new StructurePlaceSettings(), serverLevel.random, 2);
        return Utils.placeAntennaBlock(pos, serverLevel, recipe, pad);
    }

    public static Vec3 placeAntennaBlock(BlockPos initialPos, ServerLevel serverLevel, SpaceStationRecipe recipe, LaunchPad pad) {
        BlockPos pos = initialPos.offset((int)recipe.antenna_position().x, (int)recipe.antenna_position().y, (int)recipe.antenna_position().z);
        AntennaBlockEntity antennaBlockEntity = new AntennaBlockEntity(pos, ((Block)BlocksRegistry.ANTENNA.get()).defaultBlockState());
        LaunchPad newPad = new LaunchPad(pad.id(), Utils.blockPosToVec3(pos), pad.dimension(), pad.name(), pad.isPublic(), pad.owner(), pad.whitelist());
        antennaBlockEntity.setLaunchPad(newPad, true);
        serverLevel.setBlock(pos, ((Block)BlocksRegistry.ANTENNA.get()).defaultBlockState(), 1);
        serverLevel.setBlockEntity((BlockEntity)antennaBlockEntity);
        return Utils.blockPosToVec3(pos);
    }

    public static boolean isHoveredOnSprite(int x, int y, int width, int height, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public static Vec3 blockPosToVec3(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static void handleGravityChange(LivingEntity entity, Level level) {
        if (!SpaceSuitModules.containsInModules(entity.getItemBySlot(EquipmentSlot.CHEST), ((Item)ItemsRegistry.MODULE_GRAVITY_NORMALIZER.get()).getDefaultInstance())) {
            ResourceLocation dimension = level.dimension().location();
            if (!PlanetUtil.isPlanet(dimension) || dimension.equals((Object)StellarisData.OVERWORLD) || !Stellaris.CONFIG.gravityConfig.customEntityGravity) {
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.GRAVITY, ((Attribute)Attributes.GRAVITY.value()).getDefaultValue());
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, ((Attribute)Attributes.SAFE_FALL_DISTANCE.value()).getDefaultValue());
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, ((Attribute)Attributes.FALL_DAMAGE_MULTIPLIER.value()).getDefaultValue());
            } else if (PlanetUtil.isPlanet(dimension)) {
                float stellaris$regularGravity = PlanetUtil.getPlanet(dimension).gravity();
                double stellaris$gravity = Utils.MPS2ToMCG(stellaris$regularGravity);
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.GRAVITY, ((Attribute)Attributes.GRAVITY.value()).sanitizeValue(stellaris$gravity));
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, ((Attribute)Attributes.SAFE_FALL_DISTANCE.value()).sanitizeValue(3.0 / ((double)stellaris$regularGravity / 9.80665)));
                Utils.trySetAttribute(entity, (Holder<Attribute>)Attributes.FALL_DAMAGE_MULTIPLIER, ((Attribute)Attributes.FALL_DAMAGE_MULTIPLIER.value()).sanitizeValue((double)stellaris$regularGravity / 9.80665));
            }
        }
    }

    public static void trySetAttribute(LivingEntity entity, Holder<Attribute> attribute, double value) {
        AttributeInstance attributeInstance = entity.getAttribute(attribute);
        if (attributeInstance != null) {
            attributeInstance.setBaseValue(value);
        }
    }
}

