/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.screens.components.TexturedButton;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.client.screens.info.GalaxyInfo;
import com.st0x0ef.stellaris.common.menus.GalaxyMenu;
import com.st0x0ef.stellaris.common.network.packets.OpenPlanetScreenPacket;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class GalaxyScreen
extends AbstractContainerScreen<GalaxyMenu> {
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/galaxy_selection.png");
    public static final List<GalaxyInfo> GALAXY = new ArrayList<GalaxyInfo>();
    public static float rotationAngle = 0.0f;
    public static boolean isPausePressed = false;
    private int selectedGalaxyIndex = 0;
    int tbtWidth;
    int tbtHeight;
    int tbtX;
    int tbtY;

    public GalaxyScreen(GalaxyMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 1200;
        this.imageHeight = 1600;
    }

    protected void init() {
        super.init();
        this.tbtWidth = 32;
        this.tbtHeight = 32;
        this.tbtX = this.width - this.tbtWidth - 10;
        this.tbtY = this.height - this.tbtHeight - 10;
        isPausePressed = false;
        Object button = new TexturedButton(this.tbtX, this.tbtY, this.tbtWidth, this.tbtHeight, (Component)Component.translatable((String)"stellaris.gui.travel_to_planet"), btn -> {
            Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f, 1.0f);
            NetworkManager.sendToServer((CustomPacketPayload)new OpenPlanetScreenPacket(GALAXY.get(this.selectedGalaxyIndex).id()));
        }).tex(ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/arrow_button.png"), ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/gui/util/buttons/arrow_button_hover.png"));
        this.addRenderableWidget((GuiEventListener)button);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND_TEXTURE);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderSelectedGalaxy(graphics, partialTicks);
    }

    public void onClose() {
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        GLFW.glfwSetScrollCallback((long)windowHandle, (arg_0, arg_1, arg_2) -> ((MouseHandler)Minecraft.getInstance().mouseHandler).onScroll(arg_0, arg_1, arg_2));
        super.onClose();
        if (((GalaxyMenu)this.menu).getPlayer().stellaris$isPlanetMenuOpen()) {
            NetworkManager.sendToServer((CustomPacketPayload)new OpenPlanetScreenPacket(GALAXY.get(this.selectedGalaxyIndex).id()));
        }
    }

    public static GalaxyInfo findByNameGalaxy(String id) {
        for (GalaxyInfo body : GALAXY) {
            if (!body.id().equals(id)) continue;
            return body;
        }
        Stellaris.LOG.warn("Galaxy not found : {}", (Object)id);
        return null;
    }

    private void renderSelectedGalaxy(GuiGraphics guiGraphics, float partialTicks) {
        Font font = Minecraft.getInstance().font;
        int galaxyWidth = 192;
        int galaxyHeight = 192;
        int galaxyX = (this.width - galaxyWidth) / 2;
        int galaxyY = (this.height - galaxyHeight) / 2;
        if (!isPausePressed) {
            rotationAngle -= partialTicks * 0.005f;
        }
        if (!GALAXY.isEmpty()) {
            GalaxyInfo selectedGalaxy = GALAXY.get(this.selectedGalaxyIndex);
            ScreenHelper.drawTexturewithRotation(guiGraphics, selectedGalaxy.texture(), galaxyX, galaxyY, 0, 0, galaxyWidth, galaxyHeight, galaxyWidth, galaxyHeight, rotationAngle);
            int nameWidth = font.width((FormattedText)selectedGalaxy.getTranslatable());
            guiGraphics.drawString(font, selectedGalaxy.getTranslatable(), (this.width - nameWidth) / 2, 10, 0xFFFFFF);
            String infoText = "You can change the galaxies with \u2190 \u2192";
            int infoWidth = font.width(infoText);
            guiGraphics.drawString(font, infoText, (this.width - infoWidth) / 2, this.height - 30, 0xAAAAAA);
        } else {
            String noGalaxy = "No Galaxies";
            int nameWidth = font.width(noGalaxy);
            guiGraphics.drawString(font, noGalaxy, (this.width - nameWidth) / 2, 10, 0xFFFFFF);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            if (!GALAXY.isEmpty()) {
                this.selectedGalaxyIndex = (this.selectedGalaxyIndex - 1 + GALAXY.size()) % GALAXY.size();
            }
            return true;
        }
        if (keyCode == 262) {
            if (!GALAXY.isEmpty()) {
                this.selectedGalaxyIndex = (this.selectedGalaxyIndex + 1) % GALAXY.size();
            }
            return true;
        }
        if (keyCode == 88) {
            isPausePressed = !isPausePressed;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

