/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.entity.custom.elementals;

import com.ludwici.slimeoverhaul.Content;
import com.ludwici.slimeoverhaul.entity.custom.BaseSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.FlameSlime;
import com.ludwici.slimeoverhaul.entity.custom.variants.WaterSlimeVariant;
import java.util.EnumSet;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class WaterSlime
extends BaseSlime
implements Bucketable {
    public BlockPos fireBlockPos;
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(WaterSlime.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(WaterSlime.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public WaterSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new MoveToFireGoal(this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, FlameSlime.class, true));
    }

    @Override
    protected Goal getFloatGoal() {
        return new SlimeWaterMoveGoal(this);
    }

    public void push(Entity entity) {
        super.push(entity);
        if (entity instanceof FlameSlime && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)entity);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
        builder.define(VARIANT, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("Variant", this.getVariant().getId());
        compoundTag.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setVariant(WaterSlimeVariant.byId(compoundTag.getInt("Variant")));
        this.setFromBucket(compoundTag.getBoolean("FromBucket"));
    }

    public WaterSlimeVariant getVariant() {
        return WaterSlimeVariant.byId((Integer)this.entityData.get(VARIANT));
    }

    public void setVariant(WaterSlimeVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean bl) {
        this.entityData.set(FROM_BUCKET, (Object)bl);
    }

    public void saveToBucketTag(ItemStack itemStack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)itemStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> {
            compoundTag.putInt("Variant", this.getVariant().getId());
            compoundTag.putInt("Size", this.getSize() - 1);
        });
    }

    public void loadFromBucketTag(CompoundTag compoundTag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compoundTag);
        this.setVariant(WaterSlimeVariant.byId(compoundTag.getInt("Variant")));
        this.setSize(compoundTag.getInt("Size") + 1, false);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)Content.WATER_SLIME_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_EMPTY_AXOLOTL;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (mobSpawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        WaterSlimeVariant variant = (WaterSlimeVariant)((Object)Util.getRandom((Object[])WaterSlimeVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        if (serverLevelAccessor.getBiome(this.blockPosition()).is(BiomeTags.IS_OCEAN)) {
            this.setVariant(WaterSlimeVariant.OCEAN);
        } else {
            this.setVariant(WaterSlimeVariant.RIVER);
        }
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    @Override
    public boolean checkAdditionalGoals() {
        return this.fireBlockPos == null || !this.level().getBlockState(this.fireBlockPos).is(Blocks.FIRE);
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.FALLING_WATER;
    }

    @Override
    public String getSlimeType() {
        return "water_" + this.getVariant().getSerializedName();
    }

    protected InteractionResult mobInteract(Player arg, InteractionHand arg2) {
        ItemStack itemStack = arg.getItemInHand(arg2);
        if (itemStack.is(Items.BUCKET) && this.getSize() == 4) {
            ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)arg, (ItemStack)Items.WATER_BUCKET.getDefaultInstance());
            arg.setItemInHand(arg2, itemStack2);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        if (this.isTiny()) {
            return Bucketable.bucketMobPickup((Player)arg, (InteractionHand)arg2, (LivingEntity)this).orElse(super.mobInteract(arg, arg2));
        }
        return super.mobInteract(arg, arg2);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public static boolean checkSpawnRules(EntityType<WaterSlime> type, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        Holder biome = level.getBiome(blockPos);
        if (biome.is(BiomeTags.IS_OCEAN)) {
            int i = level.getSeaLevel();
            int j = i - 21;
            if (blockPos.getY() >= j && blockPos.getY() < i && level.getRandom().nextFloat() <= 0.07f) {
                return true;
            }
        } else if (biome.is(BiomeTags.IS_RIVER)) {
            if (biome.is(Tags.Biomes.IS_COLD)) {
                return false;
            }
            if (level.getRandom().nextFloat() < 0.095f) {
                return true;
            }
        } else if (level.getFluidState(blockPos).is(FluidTags.WATER) && level.getRandom().nextFloat() <= 0.1f) {
            return true;
        }
        return false;
    }

    class MoveToFireGoal
    extends Goal {
        WaterSlime slime;
        private int nextRandomizeTime;

        public MoveToFireGoal(WaterSlime mob) {
            this.slime = mob;
        }

        public boolean canUse() {
            BlockPos near;
            if (WaterSlime.this.isTiny()) {
                return false;
            }
            this.slime.fireBlockPos = near = this.findFireBlock(this.slime.blockPosition(), 10);
            return this.slime.fireBlockPos != null;
        }

        public boolean canContinueToUse() {
            return WaterSlime.this.fireBlockPos != null && WaterSlime.this.level().getBlockState(WaterSlime.this.fireBlockPos).is(Blocks.FIRE);
        }

        private BlockPos findFireBlock(BlockPos origin, int radius) {
            int searchRange = 10;
            int verticalSearchRange = 2;
            int i = searchRange;
            int j = verticalSearchRange;
            BlockPos blockPos = origin;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            int k = 0;
            while (k <= j) {
                for (int l = 0; l < i; ++l) {
                    int m = 0;
                    while (m <= l) {
                        int n;
                        int n2 = n = m < l && m > -l ? l : 0;
                        while (n <= l) {
                            mutableBlockPos.setWithOffset((Vec3i)blockPos, m, k - 1, n);
                            if (this.slime.isWithinRestriction((BlockPos)mutableBlockPos) && this.slime.level().getBlockState((BlockPos)mutableBlockPos).is(Blocks.FIRE)) {
                                return mutableBlockPos;
                            }
                            n = n > 0 ? -n : 1 - n;
                        }
                        m = m > 0 ? -m : 1 - m;
                    }
                }
                k = k > 0 ? -k : 1 - k;
            }
            return null;
        }

        public void tick() {
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = 10;
                MoveControl var2 = this.slime.getMoveControl();
                if (var2 instanceof BaseSlime.SlimeMoveControl) {
                    BaseSlime.SlimeMoveControl slimeMoveControl = (BaseSlime.SlimeMoveControl)var2;
                    double dx = (double)this.slime.fireBlockPos.getX() + 0.5 - this.slime.getX();
                    double dz = (double)this.slime.fireBlockPos.getZ() + 0.5 - this.slime.getZ();
                    float yaw = (float)(Mth.atan2((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    slimeMoveControl.setDirection(yaw, true);
                }
            }
        }
    }

    static class SlimeWaterMoveGoal
    extends Goal {
        private final WaterSlime slime;
        private int nextRandomizeTime;
        private boolean toUp = false;

        public SlimeWaterMoveGoal(WaterSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slime.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return (this.slime.isInWater() || this.slime.isInLava()) && this.slime.getMoveControl() instanceof BaseSlime.SlimeMoveControl;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            MoveControl var2;
            if (--this.nextRandomizeTime <= 0) {
                float chance = this.slime.getRandom().nextFloat();
                this.toUp = this.slime.getVariant() == WaterSlimeVariant.RIVER ? chance >= 0.7f : chance >= 0.85f;
                this.nextRandomizeTime = this.toUp ? this.adjustedTickDelay(10 + this.slime.getRandom().nextInt(40)) : this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
            }
            if (this.toUp) {
                this.slime.getJumpControl().jump();
            }
            if ((var2 = this.slime.getMoveControl()) instanceof BaseSlime.SlimeMoveControl) {
                BaseSlime.SlimeMoveControl slimeMoveControl = (BaseSlime.SlimeMoveControl)var2;
                slimeMoveControl.setWantedMovement(1.4);
            }
        }
    }
}

