/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.entity.custom.elementals;

import com.ludwici.slimeoverhaul.Content;
import com.ludwici.slimeoverhaul.entity.custom.BaseSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.WaterSlime;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.common.Tags;

public class FlameSlime
extends BaseSlime
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(FlameSlime.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public FlameSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean("FromBucket", this.fromBucket());
    }

    public void push(Entity entity) {
        super.push(entity);
        if (entity instanceof WaterSlime && this.isDealsDamage()) {
            this.dealDamage((LivingEntity)entity);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setFromBucket(compoundTag.getBoolean("FromBucket"));
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, WaterSlime.class, true));
    }

    public boolean isOnFire() {
        return false;
    }

    @Override
    public ParticleOptions getParticleType() {
        return ParticleTypes.FLAME;
    }

    @Override
    public String getSlimeType() {
        return "flame";
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean bl) {
        this.entityData.set(FROM_BUCKET, (Object)bl);
    }

    public void saveToBucketTag(ItemStack itemStack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)itemStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)itemStack, compoundTag -> compoundTag.putInt("Size", this.getSize() - 1));
    }

    public void loadFromBucketTag(CompoundTag compoundTag) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)compoundTag);
        this.setSize(compoundTag.getInt("Size") + 1, false);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)Content.FIRE_SLIME_BUCKET.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_EMPTY_AXOLOTL;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (this.isAlive() && this.isTiny() && itemStack.getItem() == Items.LAVA_BUCKET) {
            this.playSound(this.getPickupSound(), 1.0f, 1.0f);
            ItemStack itemStack2 = this.getBucketItemStack();
            this.saveToBucketTag(itemStack2);
            ItemStack itemStack3 = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)itemStack2, (boolean)false);
            player.setItemInHand(interactionHand, itemStack3);
            Level level = this.level();
            if (!level.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, itemStack2);
            }
            this.discard();
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.mobInteract(player, interactionHand);
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public static boolean checkSpawnRules(EntityType<FlameSlime> type, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        Holder biome = level.getBiome(blockPos);
        if (biome.is(Tags.Biomes.IS_OVERWORLD)) {
            if (level.getFluidState(blockPos).is(FluidTags.LAVA) && (level.getBlockState(blockPos.above()).isAir() || level.getFluidState(blockPos.above()).is(FluidTags.LAVA))) {
                return true;
            }
        } else if (biome.is(Tags.Biomes.IS_NETHER)) {
            if (!biome.is(Biomes.CRIMSON_FOREST)) {
                return false;
            }
            if (level.getBlockState(blockPos.below()).isAir()) {
                return false;
            }
            if (level.getFluidState(blockPos).is(FluidTags.LAVA)) {
                return false;
            }
            if (level.getRandom().nextFloat() <= 0.1f) {
                return true;
            }
        }
        return false;
    }
}

