/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.entity.custom;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.NotImplementedException;

public class BaseSlime
extends Slime {
    public BaseSlime(EntityType<? extends Slime> entityType, Level level) {
        super(entityType, level);
        this.moveControl = this.initMoveControl();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, this.getFloatGoal());
        this.goalSelector.addGoal(2, this.getAttackGoal());
        this.goalSelector.addGoal(3, this.getDirectionGoal());
        this.goalSelector.addGoal(5, this.getJumpGoal());
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> Math.abs(livingEntity.getY() - this.getY()) <= 4.0));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected MoveControl initMoveControl() {
        return new SlimeMoveControl<BaseSlime>(this);
    }

    protected Goal getFloatGoal() {
        return new SlimeFloatGoal(this);
    }

    protected Goal getAttackGoal() {
        return new SlimeAttackGoal(this);
    }

    public boolean canAttack(LivingEntity target) {
        return super.canAttack(target);
    }

    protected Goal getDirectionGoal() {
        return new SlimeRandomDirectionGoal(this);
    }

    protected Goal getJumpGoal() {
        return new SlimeKeepOnJumpingGoal(this);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 0.0);
    }

    public String getSlimeType() {
        throw new NotImplementedException("You should set slime type for getting valid texture in renderer class");
    }

    protected void dealDamage(LivingEntity livingEntity) {
        super.dealDamage(livingEntity);
    }

    protected boolean isDealsDamage() {
        return this.isEffectiveAi();
    }

    public ParticleOptions getParticleType() {
        return super.getParticleType();
    }

    public float getSoundVolume() {
        return super.getSoundVolume();
    }

    public SoundEvent getSquishSound() {
        return super.getSquishSound();
    }

    public int getJumpDelay() {
        return super.getJumpDelay();
    }

    public boolean checkAdditionalGoals() {
        return true;
    }

    protected float getSoundPitch() {
        float f = this.isTiny() ? 1.4f : 0.8f;
        return ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * f;
    }

    protected static class SlimeMoveControl<T extends BaseSlime>
    extends MoveControl {
        protected float yRot;
        protected int jumpDelay;
        protected final T slime;
        protected boolean isAggressive;

        public SlimeMoveControl(T slime) {
            super(slime);
            this.slime = slime;
            this.yRot = 180.0f * slime.getYRot() / (float)Math.PI;
        }

        public void setWantedPosition(double d, double e, double f, double g) {
            super.setWantedPosition(d, e, f, g);
        }

        public void setDirection(float f, boolean bl) {
            this.yRot = f;
            this.isAggressive = bl;
        }

        public void setWantedMovement(double d) {
            this.speedModifier = d;
            this.operation = MoveControl.Operation.MOVE_TO;
        }

        public void onJump() {
            this.slime.getJumpControl().jump();
            if (((BaseSlime)this.slime).doPlayJumpSound()) {
                this.slime.playSound(((BaseSlime)this.slime).getJumpSound(), ((BaseSlime)((Object)this.slime)).getSoundVolume(), ((BaseSlime)((Object)this.slime)).getSoundPitch());
            }
        }

        public void onFall() {
        }

        public void tick() {
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.yRot, 90.0f));
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
            } else {
                this.operation = MoveControl.Operation.WAIT;
                if (this.mob.onGround()) {
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = ((BaseSlime)((Object)this.slime)).getJumpDelay();
                        if (this.isAggressive) {
                            this.jumpDelay /= 3;
                        }
                        this.onJump();
                    } else {
                        ((BaseSlime)((Object)this.slime)).xxa = 0.0f;
                        ((BaseSlime)((Object)this.slime)).zza = 0.0f;
                        this.mob.setSpeed(0.0f);
                    }
                } else {
                    this.onFall();
                    this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                }
            }
        }
    }

    protected static class SlimeFloatGoal
    extends Goal {
        private final BaseSlime slime;

        public SlimeFloatGoal(BaseSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
            slime.getNavigation().setCanFloat(true);
        }

        public boolean canUse() {
            return (this.slime.isInWater() || this.slime.isInLava()) && this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            MoveControl var2;
            if (this.slime.getRandom().nextFloat() < 0.8f) {
                this.slime.getJumpControl().jump();
            }
            if ((var2 = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)var2;
                slimeMoveControl.setWantedMovement(1.2);
            }
        }
    }

    protected static class SlimeAttackGoal
    extends Goal {
        private final BaseSlime slime;
        private int growTiredTimer;

        public SlimeAttackGoal(BaseSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingEntity = this.slime.getTarget();
            if (livingEntity == null) {
                return false;
            }
            return !this.slime.canAttack(livingEntity) ? false : this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public void start() {
            this.growTiredTimer = SlimeAttackGoal.reducedTickDelay((int)300);
            super.start();
        }

        public boolean canContinueToUse() {
            LivingEntity livingEntity = this.slime.getTarget();
            if (livingEntity == null) {
                return false;
            }
            if (!this.slime.canAttack(livingEntity)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            MoveControl var3;
            LivingEntity livingEntity = this.slime.getTarget();
            if (livingEntity != null) {
                this.slime.lookAt((Entity)livingEntity, 10.0f, 10.0f);
            }
            if ((var3 = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)var3;
                slimeMoveControl.setDirection(this.slime.getYRot(), this.slime.isDealsDamage());
            }
        }
    }

    protected static class SlimeRandomDirectionGoal
    extends Goal {
        private final BaseSlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SlimeRandomDirectionGoal(BaseSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return this.slime.getTarget() == null && this.slime.checkAdditionalGoals() && (this.slime.onGround() || this.slime.isInWater() || this.slime.isInLava() || this.slime.hasEffect(MobEffects.LEVITATION)) && this.slime.getMoveControl() instanceof SlimeMoveControl;
        }

        public void tick() {
            MoveControl var2;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
                this.chosenDegrees = this.slime.getRandom().nextInt(360);
            }
            if ((var2 = this.slime.getMoveControl()) instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)var2;
                slimeMoveControl.setDirection(this.chosenDegrees, false);
            }
        }
    }

    protected static class SlimeKeepOnJumpingGoal
    extends Goal {
        private final BaseSlime slime;

        public SlimeKeepOnJumpingGoal(BaseSlime slime) {
            this.slime = slime;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return !this.slime.isPassenger();
        }

        public void tick() {
            MoveControl var2 = this.slime.getMoveControl();
            if (var2 instanceof SlimeMoveControl) {
                SlimeMoveControl slimeMoveControl = (SlimeMoveControl)var2;
                slimeMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

