/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.entity.client;

import com.ludwici.slimeoverhaul.entity.custom.BaseSlime;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SlimeOuterLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class BaseSlimeRenderer
extends MobRenderer<BaseSlime, SlimeModel<BaseSlime>> {
    public BaseSlimeRenderer(EntityRendererProvider.Context arg) {
        super(arg, (EntityModel)new SlimeModel(arg.bakeLayer(ModelLayers.SLIME)), 0.25f);
        this.addLayer((RenderLayer)new SlimeOuterLayer((RenderLayerParent)this, arg.getModelSet()));
    }

    public void render(BaseSlime arg, float f, float g, PoseStack arg2, MultiBufferSource arg3, int i) {
        this.shadowRadius = 0.25f * (float)arg.getSize();
        super.render((LivingEntity)arg, f, g, arg2, arg3, i);
    }

    protected void scale(BaseSlime arg, PoseStack arg2, float f) {
        float g = 0.999f;
        arg2.scale(0.999f, 0.999f, 0.999f);
        arg2.translate(0.0f, 0.001f, 0.0f);
        float h = arg.getSize();
        float i = Mth.lerp((float)f, (float)arg.oSquish, (float)arg.squish) / (h * 0.5f + 1.0f);
        float j = 1.0f / (i + 1.0f);
        arg2.scale(j * h, 1.0f / j * h, j * h);
    }

    public ResourceLocation getTextureLocation(BaseSlime arg) {
        return ResourceLocation.fromNamespaceAndPath((String)"slimeoverhaul", (String)("textures/entity/slime/" + arg.getSlimeType() + "_slime.png"));
    }
}

