/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public class AntiDepthEffect
extends MobEffect {
    private Fluid fluid;

    public AntiDepthEffect(MobEffectCategory mobEffectCategory, Fluid fluidType, int color) {
        super(mobEffectCategory, color);
        this.fluid = fluidType;
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int i) {
        if (this.checkLiquid(livingEntity)) {
            Player player;
            if (livingEntity instanceof Player && (player = (Player)livingEntity).isSpectator()) {
                return true;
            }
            Vec3 initialVec = livingEntity.getDeltaMovement();
            double value = initialVec.y;
            livingEntity.setDeltaMovement(initialVec.x, value += (0.8 - initialVec.y) * 0.4, initialVec.z);
        }
        return true;
    }

    protected boolean checkLiquid(LivingEntity livingEntity) {
        return livingEntity.getEyeInFluidType() == this.fluid.getFluidType();
    }

    public boolean shouldApplyEffectTickThisTick(int i, int j) {
        return true;
    }
}

