/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul.datagen;

import com.ludwici.crumbslib.api.CrumbSupplier;
import com.ludwici.crumbslib.api.EntityHelper;
import com.ludwici.slimeoverhaul.Content;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModEntityLootTableProvider
extends EntityLootSubProvider {
    protected ModEntityLootTableProvider(HolderLookup.Provider arg2) {
        super(FeatureFlags.DEFAULT_FLAGS, arg2);
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return EntityHelper.ENTITY_TYPES.getEntries().stream().map(e -> (EntityType)e.value());
    }

    public void generate() {
        this.slimeLoot(Content.AIR_SLIME, Content.AIR_SLIME_BALL);
        this.slimeLoot(Content.WATER_SLIME, Content.WATER_SLIME_BALL);
        this.slimeLoot(Content.EARTH_SLIME, Content.EARTH_SLIME_BALL);
        this.slimeLoot(Content.FLAME_SLIME, Content.FIRE_SLIME_BALL);
    }

    private <T extends Entity> void slimeLoot(CrumbSupplier<EntityType<T>> entity, CrumbSupplier<Item> loot) {
        this.add((EntityType)entity.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)loot.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)))).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)SlimePredicate.sized((MinMaxBounds.Ints)MinMaxBounds.Ints.exactly((int)1)))))));
    }
}

