/*
 * Decompiled with CFR 0.152.
 */
package com.ludwici.slimeoverhaul;

import com.ludwici.crumbslib.api.AdvancementHelper;
import com.ludwici.crumbslib.api.BlockHelper;
import com.ludwici.crumbslib.api.CreativeTabHelper;
import com.ludwici.crumbslib.api.EntityHelper;
import com.ludwici.crumbslib.api.EventHelper;
import com.ludwici.crumbslib.api.ItemHelper;
import com.ludwici.crumbslib.api.MobEffectHelper;
import com.ludwici.crumbslib.api.ModHelper;
import com.ludwici.crumbslib.api.PotionHelper;
import com.ludwici.slimeoverhaul.Content;
import com.ludwici.slimeoverhaul.entity.client.BaseSlimeRenderer;
import com.ludwici.slimeoverhaul.entity.custom.BaseSlime;
import com.ludwici.slimeoverhaul.entity.custom.elementals.EarthSlime;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@Mod(value="slimeoverhaul")
public class SlimeOverhaulMod {
    public static final String MODID = "slimeoverhaul";
    private static Minecraft minecraft;
    private static boolean canDoubleJump;

    public SlimeOverhaulMod(IEventBus modEventBus, ModContainer modContainer) {
        ModHelper.init((IEventBus)modEventBus, (IEventBus)NeoForge.EVENT_BUS, (String)MODID);
        EntityHelper.initBus();
        ItemHelper.initBus();
        BlockHelper.initBus();
        PotionHelper.initBus();
        MobEffectHelper.initBus();
        CreativeTabHelper.initBus();
        modEventBus.addListener(Content::spawns);
        EventHelper.addBrewingRecipeEvent(Content::registerPotions);
        EventHelper.addAnvilUpdateEvent(Content::registerAnvilEvent);
        EventHelper.addEventRenderers(event -> {
            event.registerEntityRenderer((EntityType)Content.AIR_SLIME.get(), BaseSlimeRenderer::new);
            event.registerEntityRenderer((EntityType)Content.WATER_SLIME.get(), BaseSlimeRenderer::new);
            event.registerEntityRenderer((EntityType)Content.EARTH_SLIME.get(), BaseSlimeRenderer::new);
            event.registerEntityRenderer((EntityType)Content.FLAME_SLIME.get(), BaseSlimeRenderer::new);
        });
        EventHelper.addAttributeEvent(event -> {
            event.put((EntityType)Content.AIR_SLIME.get(), BaseSlime.createMobAttributes().build());
            event.put((EntityType)Content.WATER_SLIME.get(), BaseSlime.createMobAttributes().build());
            event.put((EntityType)Content.EARTH_SLIME.get(), EarthSlime.createMobAttributes().build());
            event.put((EntityType)Content.FLAME_SLIME.get(), BaseSlime.createMobAttributes().build());
        });
        Content.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::handleKeyBindings);
        }
        NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::onKnock);
        NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::onInv);
        NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::onTooltip);
        NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::onShieldBlock);
        NeoForge.EVENT_BUS.addListener(SlimeOverhaulMod::onTrade);
    }

    private static void onTrade(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.CARTOGRAPHER) {
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(2)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 8), new ItemStack((ItemLike)Content.PATTERN_SLIME.get(), 1), 12, 3, 0.05f));
        }
    }

    private static void onTooltip(ItemTooltipEvent event) {
        ItemStack item = event.getItemStack();
        if (item.is(Tags.Items.TOOLS_SHIELD)) {
            List tooltipComponents = event.getToolTip();
            CustomData data = (CustomData)item.get(DataComponents.CUSTOM_DATA);
            if (data != null) {
                CompoundTag tag = data.copyTag();
                int bounce = tag.getInt("bounce");
                tooltipComponents.add(Component.translatable((String)"slimeoverhaul.earth_power", (Object[])new Object[]{bounce}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    private static void onInv(AnvilRepairEvent event) {
        ServerPlayer serverPlayer;
        AdvancementHolder advancement;
        Player player;
        CompoundTag tag;
        CustomData data;
        ItemStack item = event.getOutput();
        if (item.is(Tags.Items.TOOLS_SHIELD) && (data = (CustomData)item.get(DataComponents.CUSTOM_DATA)) != null && (tag = data.copyTag()).contains("bounce") && (player = event.getEntity()) instanceof ServerPlayer && (advancement = AdvancementHelper.getAdvancement((ServerPlayer)(serverPlayer = (ServerPlayer)player), (String)"slimeoverhaul/earth_power")) != null) {
            serverPlayer.getAdvancements().award(advancement, "bounce_shield");
        }
    }

    private static void onShieldBlock(LivingShieldBlockEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack shield = entity.getItemInHand(entity.getUsedItemHand());
        if (shield.is(Tags.Items.TOOLS_SHIELD)) {
            SlimeOverhaulMod.checkShieldBounce(shield, event, entity);
        }
    }

    private static void checkShieldBounce(ItemStack shield, LivingShieldBlockEvent event, LivingEntity entity) {
        CompoundTag tag;
        CustomData data = (CustomData)shield.get(DataComponents.CUSTOM_DATA);
        if (data != null && (tag = data.copyTag()).contains("bounce")) {
            Player player = (Player)entity;
            int bounce = tag.getInt("bounce");
            if (player != null && player.isCreative()) {
                return;
            }
            --bounce;
            DamageContainer container = event.getDamageContainer();
            DamageSource damageSource = container.getSource();
            Entity entity2 = damageSource.getDirectEntity();
            if (entity2 instanceof Projectile) {
                Projectile projectile = (Projectile)entity2;
            } else if (damageSource.isDirect()) {
                Entity target = damageSource.getDirectEntity();
                DamageSource newDamage = new DamageSource(damageSource.typeHolder(), (Entity)player, (Entity)player);
                target.hurt(newDamage, container.getOriginalDamage());
            }
            if (bounce > 0) {
                tag.putInt("bounce", bounce);
            } else {
                tag.remove("bounce");
                if (player != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"slimeoverhaul.lost_earth_power"));
                }
            }
            shield.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }

    private static void onKnock(LivingKnockBackEvent event) {
        if (event.getEntity().hasEffect(Content.KNOCK_BACK_EFFECT.getHolder())) {
            event.setCanceled(true);
        }
    }

    private static void handleKeyBindings(InputEvent.Key event) {
        LocalPlayer player;
        if (minecraft == null) {
            minecraft = Minecraft.getInstance();
        }
        if (SlimeOverhaulMod.minecraft.player == null) {
            return;
        }
        if (!(event.getAction() != 1 || event.getKey() != SlimeOverhaulMod.minecraft.options.keyJump.getKey().getValue() || !canDoubleJump || (player = SlimeOverhaulMod.minecraft.player).isCreative() || player.isSpectator() || player.onGround() || player.onClimbable() || player.isInWaterOrBubble() || ElytraItem.isFlyEnabled((ItemStack)player.getItemBySlot(EquipmentSlot.CHEST)) || player.isPassenger() || !player.hasEffect(Content.DOUBLE_JUMP_EFFECT.getHolder()))) {
            SlimeOverhaulMod.minecraft.player.jumpFromGround();
            canDoubleJump = false;
        }
        if (SlimeOverhaulMod.minecraft.player.onGround()) {
            canDoubleJump = true;
        }
    }

    static {
        canDoubleJump = true;
    }

    @EventBusSubscriber(modid="slimeoverhaul", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }
}

