/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.core.mixin.common;

import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract boolean hasEffect(Holder<MobEffect> var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(Holder<MobEffect> var1);

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isFullyFrozen() {
        return super.isFullyFrozen() || this.hasEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get()));
    }

    public int getTicksFrozen() {
        return this.hasEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get())) ? this.getEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get())).getDuration() : super.getTicksFrozen();
    }

    @Inject(method={"canFreeze()Z"}, at={@At(value="TAIL")}, cancellable=true)
    private void rc$canFreeze(CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((!this.hasEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get())) || this.hasEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get())) && this.isInPowderSnow) && (Boolean)cir.getReturnValue() != false ? 1 : 0));
    }

    @Inject(method={"jumpFromGround()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rc$jumpFromGround(CallbackInfo ci) {
        if (this.hasEffect((Holder<MobEffect>)((Holder)RCMobEffects.FREEZE.getHolder().get()))) {
            ci.cancel();
        }
    }

    @Inject(method={"onEffectRemoved(Lnet/minecraft/world/effect/MobEffectInstance;)V"}, at={@At(value="TAIL")})
    private void rc$onEffectRemoved(MobEffectInstance instance, CallbackInfo ci) {
        if (instance.getEffect() == RCMobEffects.FREEZE.getHolder().get() && !this.isInPowderSnow) {
            this.setTicksFrozen(0);
        }
    }
}

