/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.core.data.loot;

import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.github.teamfusion.rottencreatures.core.mixin.access.BuiltInLootTablesAccessor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public record LootBuilder(String key) {
    public static LootBuilder of(String key) {
        return new LootBuilder(key);
    }

    public ResourceKey<LootTable> build(String type) {
        return BuiltInLootTablesAccessor.callRegister((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)RottenCreatures.resource("entities/" + this.key() + "/" + type)));
    }

    public ResourceKey<LootTable> build() {
        return BuiltInLootTablesAccessor.callRegister((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)RottenCreatures.resource("entities/" + this.key())));
    }

    public static LootPool.Builder rolls(int rolls) {
        return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)rolls));
    }

    public static LootPool.Builder rolls(int min, int max) {
        return LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public static LootPoolSingletonContainer.Builder<?> entry(ItemLike entry) {
        return LootItem.lootTableItem((ItemLike)entry);
    }

    public static LootItemFunction.Builder count(int count) {
        return LootBuilder.count(count, count);
    }

    public static LootItemFunction.Builder count(int min, int max) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public static LootItemFunction.Builder looting(HolderLookup.Provider registries, int min, int max) {
        return EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)registries, (NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public static LootItemCondition.Builder chance(float chance) {
        return LootItemRandomChanceCondition.randomChance((float)chance);
    }

    public static LootItemCondition.Builder chanceWithLooting(HolderLookup.Provider registries, float chance, float loot) {
        return LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)registries, (float)chance, (float)loot);
    }

    public static LootItemCondition.Builder killedByPlayer() {
        return LootItemKilledByPlayerCondition.killedByPlayer();
    }
}

