/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.zap.goal;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;

public class ZapFollowLeaderGoal
extends Goal {
    private final PathfinderMob entity;
    private LivingEntity leader;
    private final Class<? extends LivingEntity> leaderType;
    private final double speedModifier;
    private int timeToRecalculatePath;

    public ZapFollowLeaderGoal(PathfinderMob entity, Class<? extends LivingEntity> leaderType, double speedModifier) {
        this.entity = entity;
        this.leaderType = leaderType;
        this.speedModifier = speedModifier;
    }

    public boolean canUse() {
        List entities = this.entity.level().getEntitiesOfClass(this.leaderType, this.entity.getBoundingBox().inflate(8.0, 4.0, 8.0));
        LivingEntity leader = null;
        double maxDistance = Double.MAX_VALUE;
        for (LivingEntity entity : entities) {
            double distance = this.entity.distanceToSqr((Entity)entity);
            if (!(distance <= maxDistance)) continue;
            maxDistance = distance;
            leader = entity;
        }
        if (leader == null) {
            return false;
        }
        if (maxDistance < 9.0) {
            return false;
        }
        this.leader = leader;
        return false;
    }

    public boolean canContinueToUse() {
        if (!this.leader.isAlive()) {
            return false;
        }
        double distance = this.entity.distanceTo((Entity)this.leader);
        return !(distance < 9.0) && !(distance > 256.0);
    }

    public void start() {
        this.timeToRecalculatePath = 0;
    }

    public void stop() {
        this.leader = null;
    }

    public void tick() {
        if (--this.timeToRecalculatePath <= 0) {
            this.timeToRecalculatePath = this.adjustedTickDelay(10);
            this.entity.getNavigation().moveTo((Entity)this.leader, this.speedModifier);
        }
    }
}

