/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.mummy;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.scarab.Scarab;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Mummy
extends SpellcasterZombie {
    private static final EntityDataAccessor<Boolean> DATA_IS_ANCIENT = SynchedEntityData.defineId(Mummy.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Mummy(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.xpReward = 10;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_IS_ANCIENT, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 26.0).add(Attributes.MOVEMENT_SPEED, 0.18).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.goalSelector.addGoal(4, (Goal)new SummonScarabsGoal());
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) {
            if ((double)this.getHealth() <= 18.0) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200));
            } else if ((double)this.getHealth() <= 10.0) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 1200, 1));
            } else if ((double)this.getHealth() <= 6.0) {
                this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 1200));
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        boolean hurtTarget = super.doHurtTarget(entity);
        if (hurtTarget && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance(MobEffects.HUNGER, 140 * (int)modifier, 2), (Entity)this);
            if (this.random.nextBoolean()) {
                this.summonScarabs(2);
            }
        }
        return hurtTarget;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        this.summonScarabs(3);
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.MUMMY_HEAD.get());
    }

    private void summonScarabs(int max) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            for (int i = 0; i <= this.random.nextInt(max); ++i) {
                BlockPos pos = this.blockPosition().offset(0, 1, 0);
                Scarab scarab = (Scarab)RCEntityTypes.SCARAB.get().create((Level)server);
                if (scarab == null) continue;
                if (this.isAncient()) {
                    scarab.setVariant(1);
                }
                scarab.moveTo(pos, 0.0f, 0.0f);
                scarab.finalizeSpawn((ServerLevelAccessor)server, server.getCurrentDifficultyAt(pos), MobSpawnType.MOB_SUMMONED, null);
                server.addFreshEntity((Entity)scarab);
            }
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("IsAncient", this.isAncient());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setAncient(tag.getBoolean("IsAncient"));
    }

    public boolean isBaby() {
        return false;
    }

    public void setBaby(boolean baby) {
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean isAncient() {
        return (Boolean)this.getEntityData().get(DATA_IS_ANCIENT);
    }

    private void setAncient(boolean ancient) {
        this.getEntityData().set(DATA_IS_ANCIENT, (Object)ancient);
    }

    public static boolean checkMummySpawnRules(EntityType<Mummy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Mummy.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos));
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.MUMMY_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.MUMMY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.MUMMY_DEATH.get();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        if (this.random.nextFloat() <= 0.3f) {
            this.setAncient(true);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, groupData);
    }

    class SummonScarabsGoal
    extends SpellcasterZombie.UseSpellGoal {
        SummonScarabsGoal() {
        }

        @Override
        protected void performSpellCasting() {
            Mummy.this.summonScarabs(5);
        }

        @Override
        protected int getCastingTime() {
            return 60;
        }

        @Override
        protected int getCastingInterval() {
            return Mummy.this.isAncient() ? 260 : 340;
        }

        @Override
        protected int getCastWarmupTime() {
            return 15;
        }
    }
}

