/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.frostbitten;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.burned.Burned;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FrostedIceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;

public class Frostbitten
extends Zombie {
    private static final byte SNOW_EXPLOSION_ID = 14;

    public Frostbitten(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.xpReward = 5;
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.createAttributes().add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ARMOR, 2.0);
    }

    protected void addBehaviourGoals() {
        super.addBehaviourGoals();
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Burned.class, true));
    }

    public boolean doHurtTarget(Entity entity) {
        LivingEntity living;
        boolean hurt = super.doHurtTarget(entity);
        if (hurt && this.getMainHandItem().isEmpty() && entity instanceof LivingEntity && (living = (LivingEntity)entity).canFreeze()) {
            float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            living.addEffect(new MobEffectInstance((Holder)RCMobEffects.FREEZE.getHolder().get(), 140 * (int)modifier), (Entity)this);
        }
        return hurt;
    }

    protected void onChangedBlock(ServerLevel level, BlockPos pos) {
        super.onChangedBlock(level, pos);
        if (this.onGround()) {
            BlockState state = Blocks.FROSTED_ICE.defaultBlockState();
            int i = 2;
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)pos.offset(-i, -1, -i), (BlockPos)pos.offset(i, -1, i))) {
                BlockState blockState3;
                if (!blockPos.closerToCenterThan((Position)this.position(), (double)i)) continue;
                mutable.set(blockPos.getX(), blockPos.getY() + 1, blockPos.getZ());
                BlockState blockState2 = level.getBlockState((BlockPos)mutable);
                if (!blockState2.isAir() || (blockState3 = level.getBlockState(blockPos)) != FrostedIceBlock.meltsInto() || !state.canSurvive((LevelReader)level, blockPos) || !level.isUnobstructed(state, blockPos, CollisionContext.empty())) continue;
                level.setBlockAndUpdate(blockPos, state);
                level.scheduleTick(blockPos, Blocks.FROSTED_ICE, Mth.nextInt((RandomSource)this.getRandom(), (int)60, (int)120));
            }
        }
    }

    public void die(DamageSource source) {
        if (this.isBaby()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)14);
            if (!this.level().isClientSide) {
                List entities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(5.0), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
                for (LivingEntity entity : entities) {
                    if (!entity.canFreeze()) continue;
                    float modifier = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
                    entity.addEffect(new MobEffectInstance((Holder)RCMobEffects.FREEZE.getHolder().get(), 100 * (int)modifier), (Entity)this);
                }
            }
        }
        super.die(source);
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
        if (id == 14) {
            this.createSnowExplosion();
        }
    }

    private void createSnowExplosion() {
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        for (int i = 0; i < 100; ++i) {
            double motionX = this.random.nextGaussian() * 0.2;
            double motionY = this.random.nextGaussian() * 0.2;
            double motionZ = this.random.nextGaussian() * 0.2;
            for (int j = 0; j < 20; ++j) {
                double xzAngle = this.random.nextDouble() * Math.PI * 2.0;
                double yAngle = this.random.nextDouble() * Math.PI / 2.0;
                double motionXDir = Math.cos(xzAngle) * Math.sin(yAngle);
                double motionYDir = Math.cos(yAngle);
                double motionZDir = Math.sin(xzAngle) * Math.sin(yAngle);
                this.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, posX, posY, posZ, motionX + motionXDir * 0.1, motionY + motionYDir * 0.1, motionZ + motionZDir * 0.1);
            }
        }
    }

    public boolean canBeAffected(MobEffectInstance instance) {
        return instance.getEffect() != RCMobEffects.FREEZE && super.canBeAffected(instance);
    }

    protected SoundEvent getAmbientSound() {
        return RCSoundEvents.FROSTBITTEN_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return RCSoundEvents.FROSTBITTEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return RCSoundEvents.FROSTBITTEN_DEATH.get();
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)RCBlocks.FROSTBITTEN_HEAD.get());
    }

    public static boolean checkFrostbittenSpawnRules(EntityType<Frostbitten> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Frostbitten.checkMonsterSpawnRules(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.canSeeSky(pos));
    }
}

