/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;

public abstract class SpellcasterZombie
extends Zombie {
    protected int spellCastingTickCount;

    public SpellcasterZombie(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.spellCastingTickCount = tag.getInt("SpellTicks");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SpellTicks", this.spellCastingTickCount);
    }

    public boolean isCastingSpell() {
        return this.spellCastingTickCount > 0;
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    protected int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    protected abstract class UseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        protected UseSpellGoal() {
        }

        public boolean canUse() {
            LivingEntity target = SpellcasterZombie.this.getTarget();
            if (target == null || !target.isAlive()) {
                return false;
            }
            if (SpellcasterZombie.this.isCastingSpell()) {
                return false;
            }
            return SpellcasterZombie.this.tickCount >= this.nextAttackTickCount;
        }

        public boolean canContinueToUse() {
            LivingEntity target = SpellcasterZombie.this.getTarget();
            return target != null && target.isAlive() && this.attackWarmupDelay > 0;
        }

        public void start() {
            this.attackWarmupDelay = this.adjustedTickDelay(this.getCastWarmupTime());
            SpellcasterZombie.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = SpellcasterZombie.this.tickCount + this.getCastingInterval();
        }

        public void tick() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
            }
        }

        protected abstract void performSpellCasting();

        protected int getCastWarmupTime() {
            return 20;
        }

        protected abstract int getCastingTime();

        protected abstract int getCastingInterval();
    }

    protected class CastingSpellGoal
    extends Goal {
        public CastingSpellGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return SpellcasterZombie.this.getSpellCastingTime() > 0;
        }

        public void tick() {
            if (SpellcasterZombie.this.getTarget() != null) {
                SpellcasterZombie.this.getLookControl().setLookAt((Entity)SpellcasterZombie.this.getTarget(), (float)SpellcasterZombie.this.getMaxHeadYRot(), (float)SpellcasterZombie.this.getMaxHeadXRot());
            }
        }
    }
}

