/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal;

import com.github.teamfusion.rottencreatures.client.level.entities.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.level.entities.model.ImmortalOverlayModel;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.entities.immortal.Immortal;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class ImmortalOverlayLayer<T extends Immortal>
extends RenderLayer<T, ImmortalModel<T>> {
    private final ImmortalOverlayModel<T> overlay;

    public ImmortalOverlayLayer(RenderLayerParent<T, ImmortalModel<T>> parent, EntityModelSet modelSet) {
        super(parent);
        this.overlay = new ImmortalOverlayModel(modelSet.bakeLayer(RCModelLayers.IMMORTAL_OVERLAY));
    }

    public void render(PoseStack matrices, MultiBufferSource source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        matrices.pushPose();
        matrices.scale(2.25f, 2.25f, 2.25f);
        matrices.translate(0.0f, -0.75f, 0.0f);
        VertexConsumer vertices = source.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)RottenCreatures.resource("textures/entity/immortal/immortal_overlay.png")));
        this.overlay.renderToBuffer(matrices, vertices, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }
}

