/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.renderer.immortal;

import com.github.teamfusion.rottencreatures.client.level.entities.model.ImmortalModel;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.entities.immortal.Immortal;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class DashAttackLayer<T extends Immortal>
extends RenderLayer<T, ImmortalModel<T>> {
    private final ModelPart box;

    public DashAttackLayer(RenderLayerParent<T, ImmortalModel<T>> renderLayerParent, EntityModelSet modelSet) {
        super(renderLayerParent);
        this.box = modelSet.bakeLayer(RCModelLayers.IMMORTAL_DASH).getChild("box");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("box", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 32.0f, 16.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(PoseStack matrices, MultiBufferSource source, int light, T entity, float angle, float distance, float tickDelta, float animationProgress, float yaw, float pitch) {
        if (entity.isAutoSpinAttack()) {
            VertexConsumer vertices = source.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"textures/entity/trident_riptide.png")));
            for (int i = 0; i < 3; ++i) {
                matrices.pushPose();
                float degrees = animationProgress * (float)(-(45 + i * 5));
                matrices.mulPose(Axis.YP.rotationDegrees(degrees));
                float scale = 0.75f * (float)i;
                matrices.scale(scale, scale, scale);
                matrices.translate(0.0, (double)(-0.2f + 0.6f * (float)i), 0.0);
                this.box.render(matrices, vertices, light, OverlayTexture.NO_OVERLAY);
                matrices.popPose();
            }
        }
    }
}

