/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.renderer.burned;

import com.github.teamfusion.rottencreatures.client.level.entities.model.BurnedModel;
import com.github.teamfusion.rottencreatures.client.level.entities.renderer.burned.BurnedLavaLayer;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.entities.burned.Burned;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class BurnedRenderer
extends AbstractZombieRenderer<Burned, BurnedModel> {
    public static final ResourceLocation BURNED_LOCATION = RottenCreatures.resource("textures/entity/burned/burned.png");
    public static final ResourceLocation OBSIDIAN_LOCATION = RottenCreatures.resource("textures/entity/burned/burned_obsidian.png");
    public static final ResourceLocation CRAZY_LOCATION = RottenCreatures.resource("textures/entity/burned/burned_crazy.png");

    public BurnedRenderer(EntityRendererProvider.Context context) {
        super(context, (ZombieModel)new BurnedModel(context.bakeLayer(RCModelLayers.BURNED)), (ZombieModel)new BurnedModel(context.bakeLayer(RCModelLayers.BURNED_INNER_ARMOR)), (ZombieModel)new BurnedModel(context.bakeLayer(RCModelLayers.BURNED_OUTER_ARMOR)));
        this.addLayer(new BurnedLavaLayer((RenderLayerParent<Burned, BurnedModel>)this));
    }

    public ResourceLocation getTextureLocation(Burned burned) {
        return burned.isObsidian() ? OBSIDIAN_LOCATION : (burned.isCrazy() ? CRAZY_LOCATION : BURNED_LOCATION);
    }

    protected void setupRotations(Burned burned, PoseStack matrices, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)burned, matrices, bob, yBodyRot, partialTick, scale);
        if ((double)burned.walkAnimation.speed() >= 0.01) {
            float timestamp = burned.walkAnimation.position(partialTick) + 6.0f;
            float degreeModifier = (Math.abs(timestamp % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrices.mulPose(Axis.ZP.rotationDegrees(6.5f * degreeModifier));
        }
    }
}

