/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.entities.model;

import com.github.teamfusion.rottencreatures.common.level.entities.swampy.Swampy;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class SwampyModel
extends HumanoidModel<Swampy> {
    public SwampyModel(ModelPart root) {
        super(root);
        this.crouching = true;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(64, 48).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 8.0f, 8.0f).texOffs(64, 0).addBox(-4.5f, -8.5f, -4.5f, 9.0f, 9.0f, 9.0f), PartPose.ZERO);
        root.getChild("body").addOrReplaceChild("foliage", CubeListBuilder.create().texOffs(56, 18).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 6.0f, 0.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.5f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(72, 18).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 14.0f, 5.0f), PartPose.offsetAndRotation((float)-6.0f, (float)-10.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(32, 48).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).texOffs(92, 18).addBox(-2.5f, -2.5f, -2.5f, 5.0f, 14.0f, 5.0f), PartPose.offsetAndRotation((float)6.0f, (float)-10.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)112, (int)64);
    }

    public void setupAnim(Swampy swampy, float limbSwing, float limbSwingAmount, float animationProgress, float headYaw, float headPitch) {
        super.setupAnim((LivingEntity)swampy, limbSwing, limbSwingAmount, animationProgress, headYaw, headPitch);
        SwampyModel.animateZombieArms(this.leftArm, this.rightArm, swampy.isAggressive(), this.attackTime, animationProgress);
    }

    public static void animateZombieArms(ModelPart leftArm, ModelPart rightArm, boolean isAggressive, float attackTime, float animProgress) {
        float j = (float)(-Math.PI) / (isAggressive ? 3.5f : 10.0f);
        float h = Mth.sin((float)(attackTime * (float)Math.PI));
        float i = Mth.sin((float)((1.0f - (1.0f - attackTime) * (1.0f - attackTime)) * (float)Math.PI));
        rightArm.zRot = 0.0f;
        leftArm.zRot = 0.0f;
        rightArm.yRot = -(0.1f - h * 0.6f);
        leftArm.yRot = 0.1f - h * 0.6f;
        rightArm.xRot = j;
        leftArm.xRot = j;
        rightArm.xRot += h * 1.2f - i * 0.4f;
        leftArm.xRot += h * 1.2f - i * 0.4f;
        AnimationUtils.bobArms((ModelPart)rightArm, (ModelPart)leftArm, (float)animProgress);
    }
}

