/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.client.level.blockentities.renderer;

import com.github.teamfusion.rottencreatures.client.level.blockentities.model.TreasureChestBlockModel;
import com.github.teamfusion.rottencreatures.client.registries.RCModelLayers;
import com.github.teamfusion.rottencreatures.common.level.blockentities.TreasureChestBlockEntity;
import com.github.teamfusion.rottencreatures.common.level.blocks.TreasureChestBlock;
import com.github.teamfusion.rottencreatures.core.RottenCreatures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TreasureChestBlockRenderer
implements BlockEntityRenderer<TreasureChestBlockEntity> {
    private final TreasureChestBlockModel model;
    private static final Map<BlockPos, ChestAnimationState> ANIMATION_STATES = new WeakHashMap<BlockPos, ChestAnimationState>();

    public TreasureChestBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new TreasureChestBlockModel(context.bakeLayer(RCModelLayers.TREASURE_CHEST));
    }

    public void render(TreasureChestBlockEntity blockEntity, float partialTick, PoseStack matrices, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.getBlockState();
        float yRot = 22.5f * (float)((Integer)state.getValue((Property)TreasureChestBlock.ROTATION)).intValue();
        boolean isOpen = (Boolean)state.getValue((Property)TreasureChestBlock.OPEN);
        BlockPos pos = blockEntity.getBlockPos();
        ChestAnimationState animState = ANIMATION_STATES.computeIfAbsent(pos, p -> new ChestAnimationState(isOpen ? 1.0f : 0.0f));
        long currentTime = System.currentTimeMillis();
        float deltaTime = Math.min(0.1f, (float)(currentTime - animState.lastUpdateTime) / 100.0f);
        animState.lastUpdateTime = currentTime;
        animState.prevOpenness = animState.openness;
        if (isOpen && animState.openness < 1.0f) {
            animState.openness = Math.min(animState.openness + deltaTime * 0.5f, 1.0f);
        } else if (!isOpen && animState.openness > 0.0f) {
            animState.openness = Math.max(animState.openness - deltaTime * 0.5f, 0.0f);
        }
        float animationProgress = Mth.lerp((float)partialTick, (float)animState.prevOpenness, (float)animState.openness);
        matrices.pushPose();
        matrices.translate(0.5, 0.0, 0.5);
        matrices.scale(-1.0f, -1.0f, 1.0f);
        VertexConsumer vertices = buffer.getBuffer(RenderType.entityCutoutNoCullZOffset((ResourceLocation)this.getTextureLocation()));
        this.model.setupAnim(animationProgress, yRot, 0.0f);
        this.model.renderToBuffer(matrices, vertices, packedLight, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
    }

    public ResourceLocation getTextureLocation() {
        return RottenCreatures.resource("textures/block/treasure_chest.png");
    }

    private static class ChestAnimationState {
        public float openness;
        public float prevOpenness;
        public long lastUpdateTime;

        public ChestAnimationState(float initialOpenness) {
            this.openness = initialOpenness;
            this.prevOpenness = initialOpenness;
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }
}

