/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.network.neoforge;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.Networking;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.teamresourceful.resourcefullib.common.network.base.ServerboundPacketType;
import com.teamresourceful.resourcefullib.common.network.internal.NetworkPacketPayload;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeNetworking
implements Networking {
    private static final List<Consumer<RegisterPayloadHandlersEvent>> LISTENERS = Collections.synchronizedList(new ArrayList());
    private final List<ClientboundPacketType<?>> clientPackets = new ArrayList();
    private final List<ServerboundPacketType<?>> serverPackets = new ArrayList();
    private final ResourceLocation channel;
    private final String version;
    private final boolean optional;

    public NeoForgeNetworking(ResourceLocation channel, int protocolVersion, boolean optional) {
        this.channel = channel.withSuffix("/v" + protocolVersion);
        this.version = "v" + protocolVersion;
        this.optional = optional;
        LISTENERS.add(this::onNetworkSetup);
    }

    @Override
    public <T extends Packet<T>> void register(ClientboundPacketType<T> type) {
        this.clientPackets.add(type);
    }

    @Override
    public <T extends Packet<T>> void register(ServerboundPacketType<T> type) {
        this.serverPackets.add(type);
    }

    @Override
    public <T extends Packet<T>> void sendToServer(T message) {
        PacketDistributor.sendToServer(new NetworkPacketPayload<T>(message, this.channel), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T extends Packet<T>> void sendToPlayer(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, new NetworkPacketPayload<T>(message, this.channel), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean canSendToPlayer(ServerPlayer player, PacketType<?> type) {
        return player.connection.hasChannel(type.type(this.channel));
    }

    public void onNetworkSetup(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.version);
        if (this.optional) {
            registrar = registrar.optional();
        }
        for (ClientboundPacketType<?> clientboundPacketType : this.clientPackets) {
            this.registerClientbound(registrar, clientboundPacketType);
        }
        for (ServerboundPacketType serverboundPacketType : this.serverPackets) {
            this.registerServerbound(registrar, serverboundPacketType);
        }
    }

    private <T extends Packet<T>> void registerClientbound(PayloadRegistrar registrar, ClientboundPacketType<T> type) {
        CustomPacketPayload.Type payloadType = type.type(this.channel);
        registrar.playToClient(payloadType, type.codec(payloadType), (payload, context) -> type.handle(payload.packet()).run());
    }

    private <T extends Packet<T>> void registerServerbound(PayloadRegistrar registrar, ServerboundPacketType<T> type) {
        CustomPacketPayload.Type payloadType = type.type(this.channel);
        registrar.playToServer(payloadType, type.codec(payloadType), (payload, context) -> type.handle(payload.packet()).accept(context.player()));
    }

    public static void setupNetwork(RegisterPayloadHandlersEvent event) {
        LISTENERS.forEach(listener -> listener.accept(event));
    }
}

