/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class IllusionistsMantleItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"illusion").stat(StatData.builder((String)"chance").initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"duration").initialValue(5.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-14151123).borderBottom(-14151123).textured(true).build()).beams(BeamsData.builder().startColor(-7396913).endColor(4920971).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"illusion").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!(slotContext.entity() instanceof Player) || prevStack.getItem() == stack.getItem() || this.getEntities(stack).isEmpty()) {
            return;
        }
        this.setEntities(stack, new ArrayList<UUID>());
    }

    public void addEntities(ItemStack stack, UUID uuid) {
        ArrayList<UUID> array = new ArrayList<UUID>(this.getEntities(stack));
        array.add(uuid);
        this.setEntities(stack, array);
    }

    public void removeEntities(ItemStack stack, UUID uuid) {
        ArrayList<UUID> array = new ArrayList<UUID>(this.getEntities(stack));
        array.remove(uuid);
        this.setEntities(stack, array);
    }

    public void setEntities(ItemStack stack, List<UUID> list) {
        stack.set(RANDataComponentRegistry.WOLVES, list);
    }

    public List<UUID> getEntities(ItemStack stack) {
        return (List)stack.getOrDefault(RANDataComponentRegistry.WOLVES, new ArrayList());
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.entityCutout((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)-3.0E-4f, (float)0.3556f, (float)0.0307f));
        PartDefinition cube_r1 = body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(37, 15).addBox(-5.501f, 0.3112f, -2.8444f, 11.0f, 7.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)0.2131f, (float)0.3331f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(34, 0).addBox(-4.5f, -2.2416f, 2.3602f, 9.0f, 8.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(77, 0).addBox(-5.5f, -1.0585f, 3.4436f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(9, 0).addBox(-5.5f, -0.5585f, 3.1936f, 11.0f, 24.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 36).addBox(-5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(12, 36).addBox(5.5f, -0.5585f, -2.8064f, 0.0f, 24.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(3, 24).addBox(-5.5f, -0.5585f, -2.8064f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = body.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(3, 30).addBox(-5.501f, 20.9365f, 11.0185f, 11.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0E-4f, (float)-0.0365f, (float)0.3386f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(24, 55).mirror().addBox(-2.0f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.751f, (float)2.2082f, (float)0.0538f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 55).addBox(-3.0f, -2.5f, -2.5f, 5.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.751f, (float)2.2082f, (float)0.0538f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128);
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm", "body"});
    }

    @EventBusSubscriber
    public static class IllusionistsMantleEvent {
        @SubscribeEvent
        public static void onDeathPlayer(LivingDeathEvent event) {
            IllusionistsMantleItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
            Item item = stack.getItem();
            if (!(item instanceof IllusionistsMantleItem) || (relic = (IllusionistsMantleItem)item).getEntities(stack).isEmpty()) {
                return;
            }
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            Optional<EntityDummy> illusion = relic.getEntities(stack).stream().map(arg_0 -> ((ServerLevel)level).getEntity(arg_0)).filter(Objects::nonNull).map(entity -> (EntityDummy)entity).max(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)player)));
            if (illusion.isEmpty()) {
                return;
            }
            event.setCanceled(true);
            Vec3 positionIllusion = illusion.get().position();
            illusion.get().discard();
            EntityDummy illusionSecond = new EntityDummy((Level)level);
            illusionSecond.ticksLeft = 200;
            illusionSecond.setPos(player.getX(), player.getY(), player.getZ());
            illusionSecond.setOwnerID(player.getUUID());
            level.addFreshEntity((Entity)illusionSecond);
            illusionSecond.kill();
            player.setHealth(2.0f);
            player.teleportTo(positionIllusion.x(), positionIllusion.y, positionIllusion.z);
        }

        @SubscribeEvent
        public static void onInjuredEntity(LivingDamageEvent.Post event) {
            IllusionistsMantleItem relic;
            LivingEntity attacker;
            Player player;
            block6: {
                block5: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    livingEntity = event.getSource().getEntity();
                    if (!(livingEntity instanceof LivingEntity)) break block5;
                    attacker = livingEntity;
                    if (!player.getCommandSenderWorld().isClientSide()) break block6;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
            RandomSource random = player.getRandom();
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            Item item = stack.getItem();
            if (!(item instanceof IllusionistsMantleItem) || !(relic = (IllusionistsMantleItem)item).isAbilityUnlocked(stack, "illusion") || relic.getStatValue(stack, "illusion", "chance") < (double)random.nextFloat()) {
                return;
            }
            Vec3 spawnPos = attacker.position().subtract(attacker.getLookAngle().normalize().scale(3.0));
            for (int i = 0; i < 10 && level.getBlockState(new BlockPos((int)spawnPos.x, (int)spawnPos.y, (int)spawnPos.z).above()).isSolid(); ++i) {
                spawnPos = spawnPos.add(0.0, 1.0, 0.0);
            }
            EntityDummy illusion = new EntityDummy((Level)level);
            illusion.ticksLeft = (int)Math.round(relic.getStatValue(stack, "illusion", "duration") * 20.0);
            illusion.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            illusion.setOwnerID(player.getUUID());
            illusion.getPersistentData().putBoolean("SpawnedFromRelic", true);
            level.addFreshEntity((Entity)illusion);
            level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(50 + random.nextInt(50), 150 + random.nextInt(106), 200 + random.nextInt(56)), (float)0.3f, (int)60, (float)0.95f), illusion.getX(), illusion.getY() + 0.4, illusion.getZ(), 15, 0.1, 0.1, 0.1, 0.1);
            relic.addEntities(stack, illusion.getUUID());
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
    }
}

