/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.client.renderer.entities;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.octostudios.reliquified_ars_nouveau.client.renderer.models.entities.WhirlingBroomModel;
import it.hurts.octostudios.reliquified_ars_nouveau.entities.WhirlingBroomEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class WhirlingBroomRenderer
extends EntityRenderer<WhirlingBroomEntity> {
    public WhirlingBroomRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull WhirlingBroomEntity broomEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-Mth.lerp((float)partialTick, (float)broomEntity.yHeadRotO, (float)broomEntity.yHeadRot)));
        poseStack.mulPose(Axis.XP.rotationDegrees(Mth.clamp((float)Mth.lerp((float)partialTick, (float)broomEntity.xRotO, (float)broomEntity.getXRot()), (float)-15.0f, (float)15.0f)));
        poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        poseStack.translate(0.6, (double)-0.4f, 0.0);
        RenderType renderType = RenderType.entityTranslucent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"reliquified_ars_nouveau", (String)"textures/entities/whirling_broom.png"));
        new WhirlingBroomModel().renderToBuffer(poseStack, bufferSource.getBuffer(renderType), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(WhirlingBroomEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"reliquified_ars_nouveau", (String)"textures/entities/whirling_broom.png");
    }
}

