/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.data;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;

public class DataTransformer {
    private static final Map<String, ResourceLocation> DATA_TRANSFORMS = new ConcurrentHashMap<String, ResourceLocation>();
    private static final Set<String> NAMESPACES = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final String SEPARATOR = ":";

    public static void apply(ResourceLocation from, ResourceLocation to) {
        DATA_TRANSFORMS.put(from.getNamespace() + SEPARATOR + from.getPath(), to);
        NAMESPACES.add(from.getNamespace());
    }

    public static boolean shouldCheckNamespace(String namespace) {
        return !NAMESPACES.isEmpty() && NAMESPACES.contains(namespace);
    }

    public static ResourceLocation applyTransformsIfPossible(String namespace, String path) {
        if (NAMESPACES.isEmpty() || !NAMESPACES.contains(namespace)) {
            return null;
        }
        return DATA_TRANSFORMS.get(namespace + SEPARATOR + path);
    }
}

