/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.client.event;

import com.blackgear.platform.core.mixin.access.CameraAccessor;
import com.blackgear.platform.core.mixin.access.NearPlaneAccessor;
import com.blackgear.platform.core.util.event.Event;
import com.mojang.blaze3d.shaders.FogShape;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FogRenderEvents {
    public static final Event<FogColor> FOG_COLOR = Event.create(FogColor.class);
    public static final Event<FogRendering> FOG_RENDERING = Event.create(FogRendering.class);

    protected static BlockState getStateOnCamera(Camera camera) {
        if (camera.isInitialized()) {
            Camera.NearPlane plane = camera.getNearPlane();
            CameraAccessor access = (CameraAccessor)camera;
            Iterator<Vec3> iterator = Arrays.asList(((NearPlaneAccessor)plane).getForward(), plane.getTopLeft(), plane.getTopRight(), plane.getBottomLeft(), plane.getBottomRight()).iterator();
            if (iterator.hasNext()) {
                Vec3 vector = iterator.next();
                Vec3 position = camera.getPosition().add(vector);
                return access.getLevel().getBlockState(BlockPos.containing((Position)position));
            }
        }
        return Blocks.AIR.defaultBlockState();
    }

    @FunctionalInterface
    public static interface FogColor {
        public void setupColor(GameRenderer var1, ColorContext var2, float var3);
    }

    @FunctionalInterface
    public static interface FogRendering {
        public void setupRendering(GameRenderer var1, RenderContext var2, float var3, float var4, float var5);
    }

    public static interface RenderContext {
        public Camera camera();

        public float fogStart();

        public float fogEnd();

        public FogShape fogShape();

        public FogType fogType();

        public FogRenderer.FogMode fogMode();

        public void fogStart(float var1);

        public void fogEnd(float var1);

        public void fogShape(FogShape var1);

        default public BlockState getStateAtCamera() {
            return FogRenderEvents.getStateOnCamera(this.camera());
        }

        public boolean isValid();

        public void build();
    }

    public static interface ColorContext {
        public Camera getCamera();

        public float getRed();

        public float getGreen();

        public float getBlue();

        public void setRed(float var1);

        public void setGreen(float var1);

        public void setBlue(float var1);

        default public BlockState getStateAtCamera() {
            return FogRenderEvents.getStateOnCamera(this.getCamera());
        }

        public boolean isValid();

        public void build();
    }
}

