/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.utils;

import java.util.Map;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.core.Direction;

public class DirectionUtils {
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final Map<Direction, Direction[]> DIRECTIONS_EXCLUDING_DIRECTION_MAP = Map.of(Direction.DOWN, new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, Direction.UP, new Direction[]{Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, Direction.NORTH, new Direction[]{Direction.DOWN, Direction.UP, Direction.SOUTH, Direction.WEST, Direction.EAST}, Direction.SOUTH, new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.WEST, Direction.EAST}, Direction.WEST, new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST}, Direction.EAST, new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST});

    public static Direction[] getAllDirectionsExcluding(Direction excluding) {
        return DIRECTIONS_EXCLUDING_DIRECTION_MAP.get(excluding);
    }

    public static Direction changeDirectionUsingTransformation(Direction dir, ItemTransform transform) {
        float yRot = transform.rotation.y();
        if (yRot == 0.0f) {
            return dir.getOpposite();
        }
        if (yRot == 90.0f) {
            return dir.getCounterClockWise();
        }
        if (yRot == 270.0f) {
            return dir.getClockWise();
        }
        return dir;
    }

    public static Direction magicalRotation(Direction face, int rotation) {
        return switch (rotation) {
            default -> face;
            case 90 -> face.getClockWise(Direction.Axis.Z);
            case 180 -> {
                if (face != Direction.NORTH && face != Direction.SOUTH) {
                    yield face.getOpposite();
                }
                yield face;
            }
            case 270 -> face.getCounterClockWise(Direction.Axis.Z);
        };
    }

    public static Direction shiftDirection(Direction facing, Direction face, int rotation) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> {
                switch (face) {
                    case UP: {
                        yield Direction.SOUTH;
                    }
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case SOUTH: {
                        yield DirectionUtils.magicalRotation(Direction.UP, rotation);
                    }
                    case NORTH: {
                        yield DirectionUtils.magicalRotation(Direction.DOWN, rotation);
                    }
                }
                yield DirectionUtils.magicalRotation(face, rotation).getOpposite();
            }
            case Direction.UP -> {
                switch (face) {
                    case UP: {
                        yield Direction.NORTH;
                    }
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case SOUTH: {
                        yield DirectionUtils.magicalRotation(Direction.DOWN, rotation);
                    }
                    case NORTH: {
                        yield DirectionUtils.magicalRotation(Direction.UP, rotation);
                    }
                }
                yield DirectionUtils.magicalRotation(face, rotation).getOpposite();
            }
            case Direction.NORTH -> DirectionUtils.magicalRotation(face, rotation);
            case Direction.SOUTH -> {
                if (face != Direction.DOWN && face != Direction.UP) {
                    yield DirectionUtils.magicalRotation(face, rotation).getOpposite();
                }
                yield DirectionUtils.magicalRotation(face, rotation);
            }
            case Direction.WEST -> {
                switch (face) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EAST: {
                        yield Direction.SOUTH;
                    }
                    case WEST: {
                        yield Direction.NORTH;
                    }
                    case UP: 
                    case DOWN: {
                        yield DirectionUtils.magicalRotation(face, rotation);
                    }
                    case SOUTH: {
                        yield DirectionUtils.magicalRotation(Direction.WEST, rotation);
                    }
                    case NORTH: 
                }
                yield DirectionUtils.magicalRotation(Direction.EAST, rotation);
            }
            case Direction.EAST -> {
                switch (face) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EAST: {
                        yield Direction.NORTH;
                    }
                    case WEST: {
                        yield Direction.SOUTH;
                    }
                    case UP: 
                    case DOWN: {
                        yield DirectionUtils.magicalRotation(face, rotation);
                    }
                    case SOUTH: {
                        yield DirectionUtils.magicalRotation(Direction.EAST, rotation);
                    }
                    case NORTH: 
                }
                yield DirectionUtils.magicalRotation(Direction.WEST, rotation);
            }
        };
    }
}

