/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.renderers;

import ca.fxco.moreculling.MoreCulling;
import ca.fxco.moreculling.utils.CullingUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.level.BlockAndTintGetter;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PaintingRenderer.class})
public abstract class PaintingRenderer_faceCullingMixin {
    @Shadow
    protected abstract void vertex(PoseStack.Pose var1, VertexConsumer var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, int var11);

    @Inject(method={"renderPainting"}, at={@At(value="HEAD")}, cancellable=true)
    private void moreculling$cullFace(PoseStack poseStack, VertexConsumer consumer, Painting painting, int width, int height, TextureAtlasSprite variant, TextureAtlasSprite paintingAtlas, CallbackInfo ci) {
        if (!MoreCulling.CONFIG.paintingCulling) {
            return;
        }
        PoseStack.Pose pose = poseStack.last();
        float negHalfX = (float)(-width) / 2.0f;
        float negHalfY = (float)(-height) / 2.0f;
        float u0 = paintingAtlas.getU0();
        float u1 = paintingAtlas.getU1();
        float v0 = paintingAtlas.getV0();
        float v1 = paintingAtlas.getV1();
        float vY = paintingAtlas.getV(0.0625f);
        float uY = paintingAtlas.getU(0.0625f);
        double d0 = 1.0 / (double)width;
        double d1 = 1.0 / (double)height;
        Direction direction = painting.getDirection();
        Direction opposite = painting.getDirection();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float x1 = negHalfX + (float)x;
                float x2 = negHalfX + (float)(x + 1);
                float y1 = negHalfY + (float)y;
                float y2 = negHalfY + (float)(y + 1);
                int paintingX = painting.getBlockX();
                int paintingY = Mth.floor((double)(painting.getY() + (double)((y1 + y2) / 2.0f)));
                int paintingZ = painting.getBlockZ();
                if (direction == Direction.NORTH) {
                    paintingX = Mth.floor((double)(painting.getX() + (double)((x1 + x2) / 2.0f)));
                }
                if (direction == Direction.WEST) {
                    paintingZ = Mth.floor((double)(painting.getZ() - (double)((x1 + x2) / 2.0f)));
                }
                if (direction == Direction.SOUTH) {
                    paintingX = Mth.floor((double)(painting.getX() - (double)((x1 + x2) / 2.0f)));
                }
                if (direction == Direction.EAST) {
                    paintingZ = Mth.floor((double)(painting.getZ() + (double)((x1 + x2) / 2.0f)));
                }
                BlockPos paintingPos = new BlockPos(paintingX, paintingY, paintingZ);
                int light = LevelRenderer.getLightColor((BlockAndTintGetter)painting.level(), (BlockPos)paintingPos);
                float fU0 = variant.getU((float)(d0 * (double)(width - x)));
                float fU1 = variant.getU((float)(d0 * (double)(width - (x + 1))));
                float fV0 = variant.getV((float)(d1 * (double)(height - y)));
                float fV1 = variant.getV((float)(d1 * (double)(height - (y + 1))));
                this.vertex(pose, consumer, x2, y1, fU1, fV0, -0.03125f, 0, 0, -1, light);
                this.vertex(pose, consumer, x1, y1, fU0, fV0, -0.03125f, 0, 0, -1, light);
                this.vertex(pose, consumer, x1, y2, fU0, fV1, -0.03125f, 0, 0, -1, light);
                this.vertex(pose, consumer, x2, y2, fU1, fV1, -0.03125f, 0, 0, -1, light);
                if (!CullingUtils.shouldCullPaintingBack(paintingPos, opposite)) {
                    this.vertex(pose, consumer, x2, y2, u1, v0, 0.03125f, 0, 0, 1, light);
                    this.vertex(pose, consumer, x1, y2, u0, v0, 0.03125f, 0, 0, 1, light);
                    this.vertex(pose, consumer, x1, y1, u0, v1, 0.03125f, 0, 0, 1, light);
                    this.vertex(pose, consumer, x2, y1, u1, v1, 0.03125f, 0, 0, 1, light);
                }
                if (y == height - 1) {
                    this.vertex(pose, consumer, x2, y2, u0, v0, -0.03125f, 0, 1, 0, light);
                    this.vertex(pose, consumer, x1, y2, u1, v0, -0.03125f, 0, 1, 0, light);
                    this.vertex(pose, consumer, x1, y2, u1, vY, 0.03125f, 0, 1, 0, light);
                    this.vertex(pose, consumer, x2, y2, u0, vY, 0.03125f, 0, 1, 0, light);
                }
                if (y == 0) {
                    this.vertex(pose, consumer, x2, y1, u0, v0, 0.03125f, 0, -1, 0, light);
                    this.vertex(pose, consumer, x1, y1, u1, v0, 0.03125f, 0, -1, 0, light);
                    this.vertex(pose, consumer, x1, y1, u1, vY, -0.03125f, 0, -1, 0, light);
                    this.vertex(pose, consumer, x2, y1, u0, vY, -0.03125f, 0, -1, 0, light);
                }
                if (x == width - 1) {
                    this.vertex(pose, consumer, x2, y2, uY, v0, 0.03125f, -1, 0, 0, light);
                    this.vertex(pose, consumer, x2, y1, uY, v1, 0.03125f, -1, 0, 0, light);
                    this.vertex(pose, consumer, x2, y1, u0, v1, -0.03125f, -1, 0, 0, light);
                    this.vertex(pose, consumer, x2, y2, u0, v0, -0.03125f, -1, 0, 0, light);
                }
                if (x != 0) continue;
                this.vertex(pose, consumer, x1, y2, uY, v0, -0.03125f, 1, 0, 0, light);
                this.vertex(pose, consumer, x1, y1, uY, v1, -0.03125f, 1, 0, 0, light);
                this.vertex(pose, consumer, x1, y1, u0, v1, 0.03125f, 1, 0, 0, light);
                this.vertex(pose, consumer, x1, y2, u0, v0, 0.03125f, 1, 0, 0, light);
            }
        }
        ci.cancel();
    }
}

