/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_useful_copper.core.entity.goal;

import common.com.cursee.more_useful_copper.core.entity.CopperGolem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;

public class CopperGolemAttackGoal
extends MeleeAttackGoal {
    private final CopperGolem entity;
    private int attackDelay = 20;
    private int ticksUntilNextAttack = 20;
    private boolean shouldCountTillNextAttack = false;

    public CopperGolemAttackGoal(PathfinderMob mob, double speedModifier, boolean followTargetIfNotVisible) {
        super(mob, speedModifier, followTargetIfNotVisible);
        this.entity = (CopperGolem)mob;
    }

    public void start() {
        super.start();
        this.attackDelay = 20;
        this.ticksUntilNextAttack = 20;
    }

    public void stop() {
        this.entity.setAttacking(false);
        super.stop();
    }

    public void tick() {
        super.tick();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity hitEntity) {
        if (this.entity.distanceToSqr((Entity)hitEntity) <= 2.0) {
            this.shouldCountTillNextAttack = true;
            if (this.ticksUntilNextAttack <= this.attackDelay) {
                this.entity.setAttacking(true);
            }
            if (this.ticksUntilNextAttack <= 0) {
                this.mob.getLookControl().setLookAt(hitEntity.getX(), hitEntity.getEyeY(), hitEntity.getZ());
                this.resetAttackCooldown();
                this.mob.swing(InteractionHand.MAIN_HAND);
                this.mob.doHurtTarget((Entity)hitEntity);
            }
        } else {
            this.resetAttackCooldown();
            this.shouldCountTillNextAttack = false;
            this.entity.setAttacking(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }
}

