/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.CacheBackedPackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.InMemoryPackResources;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.pack.DynamicResourcesInternals;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import org.jetbrains.annotations.NotNull;

public interface PackGenerationStrategy {
    public static final PackGenerationStrategy REGEN_ON_EVERY_RELOAD = new PackGenerationStrategy(){

        @Override
        public boolean needsRegeneration(IEditablePackResources packResources, Collection<PackResources> loadedPacks) {
            return true;
        }

        @Override
        public void beforeRegenerate(IEditablePackResources pack, Collection<PackResources> loadedPacks) {
        }

        @Override
        public IEditablePackResources createPackResources(PackLocationInfo info, PackType type) {
            return new InMemoryPackResources(info, type);
        }
    };
    public static final PackGenerationStrategy RUN_ONCE = new PackGenerationStrategy(){

        @Override
        public boolean needsRegeneration(IEditablePackResources packResources, Collection<PackResources> loadedPacks) {
            return packResources.isEmpty();
        }

        @Override
        public void beforeRegenerate(IEditablePackResources pack, Collection<PackResources> loadedPacks) {
        }

        @Override
        public IEditablePackResources createPackResources(PackLocationInfo info, PackType type) {
            return new InMemoryPackResources(info, type);
        }
    };
    public static final PackGenerationStrategy CACHED = new SimpleCached();

    public boolean needsRegeneration(IEditablePackResources var1, Collection<PackResources> var2);

    public void beforeRegenerate(IEditablePackResources var1, Collection<PackResources> var2);

    public IEditablePackResources createPackResources(PackLocationInfo var1, PackType var2);

    public static class SimpleCached
    implements PackGenerationStrategy {
        private static String computeCurrentFingerprint(Collection<PackResources> packs) {
            List<String> tokens = SimpleCached.computeTokens(packs);
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                for (String t : tokens) {
                    md.update(t.getBytes(StandardCharsets.UTF_8));
                    md.update((byte)31);
                }
                byte[] d = md.digest();
                StringBuilder sb = new StringBuilder(d.length * 2);
                for (byte b : d) {
                    sb.append(String.format("%02x", b));
                }
                return sb.toString();
            }
            catch (NoSuchAlgorithmException e) {
                return Integer.toHexString(tokens.toString().hashCode());
            }
        }

        @NotNull
        private static List<String> computeTokens(Collection<PackResources> packs) {
            ArrayList<String> tokens = new ArrayList<String>();
            boolean fabric = PlatHelper.getPlatform().isFabric();
            int i = 0;
            for (PackResources p : packs) {
                String id = p.packId();
                if (DynamicResourcesInternals.isKnownDynamicPack(p.location().id()) || id.startsWith("mod/") || fabric && id.startsWith("fabric") || id.startsWith("generated")) continue;
                String description = "";
                try {
                    PackMetadataSection metadataSection = (PackMetadataSection)p.getMetadataSection((MetadataSectionSerializer)PackMetadataSection.TYPE);
                    if (metadataSection != null) {
                        description = metadataSection.description().getString();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tokens.add("pack[" + i++ + "]=" + id + "@" + description);
            }
            ArrayList<CallSite> modTokens = new ArrayList<CallSite>();
            for (String mod : PlatHelper.getInstalledMods()) {
                if (fabric && mod.startsWith("fabric")) continue;
                modTokens.add((CallSite)((Object)(mod + "@" + PlatHelper.getModVersion(mod))));
            }
            Collections.sort(modTokens);
            tokens.addAll(modTokens);
            return tokens;
        }

        private void writeFingerprint(IEditablePackResources pack, String fp) {
            Path dir = this.getCachePath(pack);
            Path file = this.getCacheHashPath(pack);
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Files.writeString(file, (CharSequence)fp, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (Exception e) {
                Moonlight.LOGGER.debug("Failed writing cache fingerprint for {}: {}", (Object)pack, (Object)e.toString());
            }
        }

        private String readFingerprint(IEditablePackResources pack) {
            Path file = this.getCacheHashPath(pack);
            if (!Files.exists(file, new LinkOption[0])) {
                return "";
            }
            try {
                return Files.readString(file, StandardCharsets.UTF_8).trim();
            }
            catch (Exception e) {
                Moonlight.LOGGER.debug("Failed reading cache fingerprint for {}: {}", (Object)pack, (Object)e.toString());
                return "";
            }
        }

        private Path getCacheHashPath(IEditablePackResources pack) {
            return this.getCachePath(pack).resolve("hash.txt");
        }

        public Path getCachePath(IEditablePackResources pack) {
            return this.getCachePath(pack.location(), pack.getPackType());
        }

        public Path getCachePath(PackLocationInfo packInfo, PackType type) {
            return PlatHelper.getGamePath().resolve("dynamic-" + (type == PackType.CLIENT_RESOURCES ? "resource" : "data") + "-pack-cache").resolve(packInfo.id().replace(":", "-"));
        }

        @Override
        public boolean needsRegeneration(IEditablePackResources packResources, Collection<PackResources> loadedPacks) {
            String newHash;
            String oldHash = this.readFingerprint(packResources);
            return !oldHash.equals(newHash = SimpleCached.computeCurrentFingerprint(loadedPacks));
        }

        @Override
        public IEditablePackResources createPackResources(PackLocationInfo info, PackType type) {
            return new CacheBackedPackResources(info, type, this.getCachePath(info, type));
        }

        @Override
        public void beforeRegenerate(IEditablePackResources packResources, Collection<PackResources> loadedPacks) {
            String newHash = SimpleCached.computeCurrentFingerprint(loadedPacks);
            this.writeFingerprint(packResources, newHash);
        }
    }
}

