/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;

public class CacheBackedPackResources
extends PathPackResources
implements IEditablePackResources {
    private final Path path;
    private final PackMetadataSection metadata;
    private final PackType packType;
    private final Set<String> namespaces = new HashSet<String>();
    private final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();

    public CacheBackedPackResources(PackLocationInfo location, PackType type, Path path) {
        super(location, path);
        this.path = path;
        this.packType = type;
        this.metadata = new PackMetadataSection((Component)Component.translatable((String)"message.moonlight.cached"), SharedConstants.getCurrentVersion().getPackVersion(this.packType), Optional.empty());
    }

    public Set<String> getNamespaces(PackType type) {
        if (type != this.packType) {
            return Set.of();
        }
        return this.namespaces;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        if (packType != this.packType) {
            return;
        }
        super.listResources(packType, namespace, path, resourceOutput);
    }

    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        if (packType != this.packType) {
            return null;
        }
        return super.getResource(packType, location);
    }

    public <T> T getMetadataSection(MetadataSectionSerializer<T> serializer) {
        try {
            return (T)(serializer == PackMetadataSection.TYPE ? this.metadata : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    @Override
    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    @Override
    public void addResource(ResourceLocation id, byte[] bytes) {
        RPUtils.writeResource(id, bytes, this.path, this.packType);
    }

    @Override
    public void removeResource(ResourceLocation id) {
        Path resPath = RPUtils.getResourcePath(this.path, id, this.packType);
        try {
            Files.deleteIfExists(resPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void removeRootResource(String name) {
    }

    @Override
    public void clearAllResources() {
        try {
            Files.deleteIfExists(this.path);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PackType getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

