/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.example;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFBrowser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;

public class ExampleScreen
extends Screen {
    private static final int BROWSER_DRAW_OFFSET = 20;
    private MCEFBrowser browser;

    protected ExampleScreen(Component component) {
        super(component);
    }

    protected void init() {
        super.init();
        if (this.browser == null) {
            String url = "https://www.google.com";
            boolean transparent = true;
            this.browser = MCEF.createBrowser(url, transparent);
            this.resizeBrowser();
        }
    }

    private int mouseX(double x) {
        return (int)((x - 20.0) * this.minecraft.getWindow().getGuiScale());
    }

    private int mouseY(double y) {
        return (int)((y - 20.0) * this.minecraft.getWindow().getGuiScale());
    }

    private int scaleX(double x) {
        return (int)((x - 40.0) * this.minecraft.getWindow().getGuiScale());
    }

    private int scaleY(double y) {
        return (int)((y - 40.0) * this.minecraft.getWindow().getGuiScale());
    }

    private void resizeBrowser() {
        if (this.width > 100 && this.height > 100) {
            this.browser.resize(this.scaleX(this.width), this.scaleY(this.height));
        }
    }

    public void resize(Minecraft minecraft, int i, int j) {
        super.resize(minecraft, i, j);
        this.resizeBrowser();
    }

    public void onClose() {
        this.browser.close();
        super.onClose();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (int)this.browser.getRenderer().getTextureID());
        Tesselator t = Tesselator.getInstance();
        BufferBuilder buffer = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(20.0f, (float)(this.height - 20), 0.0f).setUv(0.0f, 1.0f).setColor(255, 255, 255, 255);
        buffer.addVertex((float)(this.width - 20), (float)(this.height - 20), 0.0f).setUv(1.0f, 1.0f).setColor(255, 255, 255, 255);
        buffer.addVertex((float)(this.width - 20), 20.0f, 0.0f).setUv(1.0f, 0.0f).setColor(255, 255, 255, 255);
        buffer.addVertex(20.0f, 20.0f, 0.0f).setUv(0.0f, 0.0f).setColor(255, 255, 255, 255);
        BufferUploader.drawWithShader((MeshData)buffer.build());
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.enableDepthTest();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.browser.sendMousePress(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.browser.sendMouseRelease(this.mouseX(mouseX), this.mouseY(mouseY), button);
        this.browser.setFocus(true);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.browser.sendMouseMove(this.mouseX(mouseX), this.mouseY(mouseY));
        super.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.browser.sendMouseWheel(this.mouseX(mouseX), this.mouseY(mouseY), scrollY, 0);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.browser.sendKeyPress(keyCode, scanCode, modifiers);
        this.browser.setFocus(true);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        this.browser.sendKeyRelease(keyCode, scanCode, modifiers);
        this.browser.setFocus(true);
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (codePoint == '\u0000') {
            return false;
        }
        this.browser.sendKeyTyped(codePoint, modifiers);
        this.browser.setFocus(true);
        return super.charTyped(codePoint, modifiers);
    }
}

