/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.element;

import guideme.compiler.IdUtils;
import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.scene.GuidebookScene;
import guideme.scene.element.FakeForwardingServerLevel;
import guideme.scene.element.SceneElementTagCompiler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ImportStructureElementCompiler
implements SceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("ImportStructure");
    }

    @Override
    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        CompoundTag compoundTag;
        ResourceLocation absStructureSrc;
        String structureSrc = el.getAttributeString("src", null);
        if (structureSrc == null) {
            errorSink.appendError(compiler, "Missing src attribute", el);
            return;
        }
        BlockPos pos = MdxAttrs.getBlockPos(compiler, errorSink, el, "pos", BlockPos.ZERO);
        try {
            absStructureSrc = IdUtils.resolveLink(structureSrc, compiler.getPageId());
        }
        catch (ResourceLocationException e) {
            errorSink.appendError(compiler, "Invalid structure path: " + structureSrc, el);
            return;
        }
        byte[] structureNbtData = compiler.loadAsset(absStructureSrc);
        if (structureNbtData == null) {
            errorSink.appendError(compiler, "Missing structure file", el);
            return;
        }
        try {
            compoundTag = absStructureSrc.getPath().toLowerCase(Locale.ROOT).endsWith(".snbt") ? NbtUtils.snbtToStructure((String)new String(structureNbtData, StandardCharsets.UTF_8)) : NbtIo.readCompressed((InputStream)new ByteArrayInputStream(structureNbtData), (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (Exception e) {
            errorSink.appendError(compiler, "Couldn't read structure: " + e.getMessage(), el);
            return;
        }
        StructureTemplate template = new StructureTemplate();
        HolderLookup.RegistryLookup blocks = scene.getLevel().registryAccess().registryOrThrow(Registries.BLOCK).asLookup();
        template.load((HolderGetter)blocks, compoundTag);
        SingleThreadedRandomSource random = new SingleThreadedRandomSource(0L);
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.setIgnoreEntities(true);
        FakeForwardingServerLevel fakeServerLevel = new FakeForwardingServerLevel((LevelAccessor)scene.getLevel());
        if (!template.placeInWorld((ServerLevelAccessor)fakeServerLevel, pos, pos, settings, (RandomSource)random, 0)) {
            errorSink.appendError(compiler, "Failed to place structure", el);
        }
    }
}

