/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.uhighlight;

import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.search.highlight.TermVectorLeafReader;
import guideme.internal.shaded.lucene.search.uhighlight.FieldOffsetStrategy;
import guideme.internal.shaded.lucene.search.uhighlight.OffsetsEnum;
import guideme.internal.shaded.lucene.search.uhighlight.OverlaySingleDocTermsLeafReader;
import guideme.internal.shaded.lucene.search.uhighlight.UHComponents;
import guideme.internal.shaded.lucene.search.uhighlight.UnifiedHighlighter;
import java.io.IOException;

public class TermVectorOffsetStrategy
extends FieldOffsetStrategy {
    public TermVectorOffsetStrategy(UHComponents components) {
        super(components);
    }

    @Override
    public UnifiedHighlighter.OffsetSource getOffsetSource() {
        return UnifiedHighlighter.OffsetSource.TERM_VECTORS;
    }

    @Override
    public OffsetsEnum getOffsetsEnum(LeafReader reader, int docId, String content) throws IOException {
        Terms tvTerms = reader.termVectors().get(docId, this.getField());
        if (tvTerms == null) {
            return OffsetsEnum.EMPTY;
        }
        TermVectorLeafReader singleDocReader = new TermVectorLeafReader(this.getField(), tvTerms);
        return this.createOffsetsEnumFromReader(new OverlaySingleDocTermsLeafReader(reader, singleDocReader, this.getField(), docId), docId);
    }
}

