/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;

final class ApproximatePriorityQueue<T> {
    private final List<T> slots = new ArrayList<T>(64);
    private long usedSlots = 0L;

    ApproximatePriorityQueue() {
        for (int i = 0; i < 64; ++i) {
            this.slots.add(null);
        }
    }

    void add(T entry, long weight) {
        assert (entry != null);
        int expectedSlot = Long.numberOfLeadingZeros(weight);
        long freeSlots = this.usedSlots ^ 0xFFFFFFFFFFFFFFFFL;
        int destinationSlot = expectedSlot + Long.numberOfTrailingZeros(freeSlots >>> expectedSlot);
        assert (destinationSlot >= expectedSlot);
        if (destinationSlot < 64) {
            this.usedSlots |= 1L << destinationSlot;
            T previous = this.slots.set(destinationSlot, entry);
            assert (previous == null);
        } else {
            this.slots.add(entry);
        }
    }

    T poll(Predicate<T> predicate) {
        T entry;
        int nextUsedSlot;
        int nextSlot = 0;
        while ((nextUsedSlot = nextSlot + Long.numberOfTrailingZeros(this.usedSlots >>> nextSlot)) < 64) {
            entry = this.slots.get(nextUsedSlot);
            if (predicate.test(entry)) {
                this.usedSlots &= 1L << nextUsedSlot ^ 0xFFFFFFFFFFFFFFFFL;
                this.slots.set(nextUsedSlot, null);
                return entry;
            }
            nextSlot = nextUsedSlot + 1;
            if (nextSlot < 64) continue;
        }
        ListIterator<T> lit = this.slots.listIterator(this.slots.size());
        while (lit.previousIndex() >= 64) {
            entry = lit.previous();
            if (!predicate.test(entry)) continue;
            lit.remove();
            return entry;
        }
        return null;
    }

    boolean contains(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        return this.slots.contains(o);
    }

    boolean isEmpty() {
        return this.usedSlots == 0L && this.slots.size() == 64;
    }

    boolean remove(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int index = this.slots.indexOf(o);
        if (index == -1) {
            return false;
        }
        if (index >= 64) {
            this.slots.remove(index);
        } else {
            this.usedSlots &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
            this.slots.set(index, null);
        }
        return true;
    }
}

